/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.customization.processors;

import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.MemberModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.service.ServiceModel;
import java.util.List;
import java.util.Map;

public final class SendEmptyAutoConstructedListAsEmptyListProcessor
implements CodegenCustomizationProcessor {
    private Map<String, List<String>> sendEmptyQueryString;

    SendEmptyAutoConstructedListAsEmptyListProcessor(Map<String, List<String>> sendEmptyQueryString) {
        this.sendEmptyQueryString = sendEmptyQueryString;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        if (this.sendEmptyQueryString == null || this.sendEmptyQueryString.isEmpty()) {
            return;
        }
        this.sanityCheck(intermediateModel);
        for (Map.Entry<String, List<String>> entry : this.sendEmptyQueryString.entrySet()) {
            String shapeName = entry.getKey();
            List<String> members = entry.getValue();
            ShapeModel shapeModel = intermediateModel.getShapes().get(shapeName);
            for (String memberName : members) {
                MemberModel memberModel = shapeModel.getMemberByName(memberName);
                memberModel.getListModel().setSendEmptyQueryString(true);
            }
        }
    }

    private void sanityCheck(IntermediateModel intermediateModel) {
        for (Map.Entry<String, List<String>> entry : this.sendEmptyQueryString.entrySet()) {
            String shapeName = entry.getKey();
            List<String> members = entry.getValue();
            ShapeModel shapeModel = intermediateModel.getShapes().get(shapeName);
            if (shapeModel == null) {
                throw new IllegalStateException(String.format("Cannot find shape [%s] in the model when processing customization config sendEmptyQueryStringParam.%s", shapeName, shapeName));
            }
            for (String memberName : members) {
                MemberModel memberModel = shapeModel.getMemberByName(memberName);
                if (memberModel == null) {
                    throw new IllegalStateException(String.format("Cannot find member [%s] in the model when processing customization config sendEmptyQueryStringParam.%s", memberName, shapeName));
                }
                if (memberModel.isList()) continue;
                throw new IllegalStateException(String.format("Member %s from shape %s must be a list", memberName, shapeName));
            }
        }
    }
}

