/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters.tasks;

import com.amazonaws.codegen.emitters.CodeWriter;
import com.amazonaws.codegen.emitters.FreemarkerGeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTaskParams;
import com.amazonaws.codegen.emitters.tasks.BaseGeneratorTasks;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.AuthPolicyActions;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.util.ImmutableMapParameter;
import java.util.Collections;
import java.util.List;

public class PolicyActionEnumGeneratorTasks
extends BaseGeneratorTasks {
    private final String policyEnumClassDir;
    private final AuthPolicyActions policyActions;
    private final Metadata metadata;

    public PolicyActionEnumGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.policyEnumClassDir = dependencies.getPathProvider().getPolicyEnumDirectory();
        this.policyActions = this.model.getCustomizationConfig().getAuthPolicyActions();
        this.metadata = this.model.getMetadata();
    }

    @Override
    protected boolean hasTasks() {
        AuthPolicyActions policyActions = this.model.getCustomizationConfig().getAuthPolicyActions();
        return policyActions == null || !policyActions.isSkip();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting policy action enum class");
        String serviceName = this.getPolicyActionServiceName();
        String actionPrefix = this.getEnumActionPrefix();
        ImmutableMapParameter dataModel = ImmutableMapParameter.of((Object)"fileHeader", (Object)this.model.getFileHeader(), (Object)"operations", this.model.getOperations().keySet(), (Object)"metadata", (Object)this.model.getMetadata(), (Object)"serviceName", (Object)serviceName, (Object)"actionPrefix", (Object)actionPrefix);
        return Collections.singletonList(new FreemarkerGeneratorTask(new CodeWriter(this.policyEnumClassDir, serviceName + "Actions"), this.freemarker.getPolicyActionClassTemplate(), dataModel));
    }

    private String getPolicyActionServiceName() {
        if (this.policyActions != null && this.policyActions.getFileNamePrefix() != null) {
            return Utils.capitialize(this.policyActions.getFileNamePrefix());
        }
        return Utils.capitialize(this.metadata.getEndpointPrefix());
    }

    private String getEnumActionPrefix() {
        if (this.policyActions != null && this.policyActions.getActionPrefix() != null) {
            return this.policyActions.getActionPrefix();
        }
        return this.metadata.getEndpointPrefix();
    }
}

