/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.customization.processors;

import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.model.config.customization.MetadataConfig;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.model.service.ServiceMetadata;
import com.amazonaws.codegen.model.service.ServiceModel;

public class MetadataModifiersProcessor
implements CodegenCustomizationProcessor {
    private final MetadataConfig metadataConfig;

    MetadataModifiersProcessor(MetadataConfig metadataConfig) {
        this.metadataConfig = metadataConfig;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
        if (this.metadataConfig == null) {
            return;
        }
        ServiceMetadata serviceMetadata = serviceModel.getMetadata();
        String customProtocol = this.metadataConfig.getProtocol();
        if (customProtocol != null) {
            serviceMetadata.setProtocol(customProtocol);
        }
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        if (this.metadataConfig == null) {
            return;
        }
        Metadata metadata = intermediateModel.getMetadata();
        String jsonContentVersion = this.metadataConfig.getJsonContentVersion();
        if (jsonContentVersion != null) {
            metadata.setJsonContentVersion(jsonContentVersion);
        }
    }
}

