/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters;

import com.amazonaws.codegen.internal.Constants;
import java.util.Map;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class JavaCodeFormatter {
    private final CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)options, (int)ToolFactory.M_FORMAT_EXISTING);
    private static final Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();

    public JavaCodeFormatter() {
        if (this.codeFormatter == null) {
            throw new RuntimeException("Unable to create code formatter to format the generated code.");
        }
    }

    public String format(String contents) {
        TextEdit edit = this.codeFormatter.format(4104, contents, 0, contents.length(), 0, Constants.LINE_SEPARATOR);
        if (edit == null) {
            return contents;
        }
        Document document = new Document(contents);
        try {
            edit.apply((IDocument)document);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to format the generated source code.", e);
        }
        return document.get();
    }

    static {
        options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
        options.put("org.eclipse.jdt.core.compiler.source", "1.6");
        options.put("org.eclipse.jdt.core.formatter.tabulation.char", "space");
        options.put("org.eclipse.jdt.core.formatter.comment.indent_parameter_description", "false");
        options.put("org.eclipse.jdt.core.formatter.alignment_for_enum_constants", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)1));
        options.put("org.eclipse.jdt.core.formatter.alignment_for_parameters_in_constructor_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
    }
}

