/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatch.model.Range;
import java.util.Date;

@SdkInternalApi
public class RangeMarshaller {
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final RangeMarshaller instance = new RangeMarshaller();

    public static RangeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Range range, ProtocolMarshaller protocolMarshaller) {
        if (range == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)range.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)range.getEndTime(), ENDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

