/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatch.model.EntityMetricData;
import java.util.List;

@SdkInternalApi
public class EntityMetricDataMarshaller {
    private static final MarshallingInfo<StructuredPojo> ENTITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Entity").build();
    private static final MarshallingInfo<List> METRICDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricData").build();
    private static final EntityMetricDataMarshaller instance = new EntityMetricDataMarshaller();

    public static EntityMetricDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(EntityMetricData entityMetricData, ProtocolMarshaller protocolMarshaller) {
        if (entityMetricData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)entityMetricData.getEntity(), ENTITY_BINDING);
            if (entityMetricData.getMetricData() != null && !entityMetricData.getMetricData().isEmpty()) {
                protocolMarshaller.marshall(entityMetricData.getMetricData(), METRICDATA_BINDING);
            }
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

