/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatch.model.AlarmContributor;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class AlarmContributorMarshaller {
    private static final MarshallingInfo<String> CONTRIBUTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContributorId").build();
    private static final MarshallingInfo<Map> CONTRIBUTORATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContributorAttributes").build();
    private static final MarshallingInfo<String> STATEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateReason").build();
    private static final MarshallingInfo<Date> STATETRANSITIONEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateTransitionedTimestamp").timestampFormat("unixTimestamp").build();
    private static final AlarmContributorMarshaller instance = new AlarmContributorMarshaller();

    public static AlarmContributorMarshaller getInstance() {
        return instance;
    }

    public void marshall(AlarmContributor alarmContributor, ProtocolMarshaller protocolMarshaller) {
        if (alarmContributor == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)alarmContributor.getContributorId(), CONTRIBUTORID_BINDING);
            protocolMarshaller.marshall(alarmContributor.getContributorAttributes(), CONTRIBUTORATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)alarmContributor.getStateReason(), STATEREASON_BINDING);
            protocolMarshaller.marshall((Object)alarmContributor.getStateTransitionedTimestamp(), STATETRANSITIONEDTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

