/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatch.model.MetricStreamStatisticsMetric;
import com.amazonaws.services.cloudwatch.model.transform.MetricStreamStatisticsConfigurationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class MetricStreamStatisticsConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private SdkInternalList<MetricStreamStatisticsMetric> includeMetrics;
    private SdkInternalList<String> additionalStatistics;

    public List<MetricStreamStatisticsMetric> getIncludeMetrics() {
        if (this.includeMetrics == null) {
            this.includeMetrics = new SdkInternalList();
        }
        return this.includeMetrics;
    }

    public void setIncludeMetrics(Collection<MetricStreamStatisticsMetric> includeMetrics) {
        if (includeMetrics == null) {
            this.includeMetrics = null;
            return;
        }
        this.includeMetrics = new SdkInternalList(includeMetrics);
    }

    public MetricStreamStatisticsConfiguration withIncludeMetrics(MetricStreamStatisticsMetric ... includeMetrics) {
        if (this.includeMetrics == null) {
            this.setIncludeMetrics((Collection<MetricStreamStatisticsMetric>)new SdkInternalList(includeMetrics.length));
        }
        for (MetricStreamStatisticsMetric ele : includeMetrics) {
            this.includeMetrics.add((Object)ele);
        }
        return this;
    }

    public MetricStreamStatisticsConfiguration withIncludeMetrics(Collection<MetricStreamStatisticsMetric> includeMetrics) {
        this.setIncludeMetrics(includeMetrics);
        return this;
    }

    public List<String> getAdditionalStatistics() {
        if (this.additionalStatistics == null) {
            this.additionalStatistics = new SdkInternalList();
        }
        return this.additionalStatistics;
    }

    public void setAdditionalStatistics(Collection<String> additionalStatistics) {
        if (additionalStatistics == null) {
            this.additionalStatistics = null;
            return;
        }
        this.additionalStatistics = new SdkInternalList(additionalStatistics);
    }

    public MetricStreamStatisticsConfiguration withAdditionalStatistics(String ... additionalStatistics) {
        if (this.additionalStatistics == null) {
            this.setAdditionalStatistics((Collection<String>)new SdkInternalList(additionalStatistics.length));
        }
        for (String ele : additionalStatistics) {
            this.additionalStatistics.add((Object)ele);
        }
        return this;
    }

    public MetricStreamStatisticsConfiguration withAdditionalStatistics(Collection<String> additionalStatistics) {
        this.setAdditionalStatistics(additionalStatistics);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIncludeMetrics() != null) {
            sb.append("IncludeMetrics: ").append(this.getIncludeMetrics()).append(",");
        }
        if (this.getAdditionalStatistics() != null) {
            sb.append("AdditionalStatistics: ").append(this.getAdditionalStatistics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricStreamStatisticsConfiguration)) {
            return false;
        }
        MetricStreamStatisticsConfiguration other = (MetricStreamStatisticsConfiguration)obj;
        if (other.getIncludeMetrics() == null ^ this.getIncludeMetrics() == null) {
            return false;
        }
        if (other.getIncludeMetrics() != null && !other.getIncludeMetrics().equals(this.getIncludeMetrics())) {
            return false;
        }
        if (other.getAdditionalStatistics() == null ^ this.getAdditionalStatistics() == null) {
            return false;
        }
        return other.getAdditionalStatistics() == null || other.getAdditionalStatistics().equals(this.getAdditionalStatistics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIncludeMetrics() == null ? 0 : this.getIncludeMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalStatistics() == null ? 0 : this.getAdditionalStatistics().hashCode());
        return hashCode;
    }

    public MetricStreamStatisticsConfiguration clone() {
        try {
            return (MetricStreamStatisticsConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricStreamStatisticsConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

