/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatch.model.transform.EntityMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Entity
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> keyAttributes;
    private Map<String, String> attributes;

    public Map<String, String> getKeyAttributes() {
        return this.keyAttributes;
    }

    public void setKeyAttributes(Map<String, String> keyAttributes) {
        this.keyAttributes = keyAttributes;
    }

    public Entity withKeyAttributes(Map<String, String> keyAttributes) {
        this.setKeyAttributes(keyAttributes);
        return this;
    }

    public Entity addKeyAttributesEntry(String key, String value) {
        if (null == this.keyAttributes) {
            this.keyAttributes = new HashMap<String, String>();
        }
        if (this.keyAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.keyAttributes.put(key, value);
        return this;
    }

    public Entity clearKeyAttributesEntries() {
        this.keyAttributes = null;
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Entity withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public Entity addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public Entity clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyAttributes() != null) {
            sb.append("KeyAttributes: ").append(this.getKeyAttributes()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        if (other.getKeyAttributes() == null ^ this.getKeyAttributes() == null) {
            return false;
        }
        if (other.getKeyAttributes() != null && !other.getKeyAttributes().equals(this.getKeyAttributes())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyAttributes() == null ? 0 : this.getKeyAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public Entity clone() {
        try {
            return (Entity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

