/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatch.model.MetricStat;

@SdkInternalApi
public class MetricStatMarshaller {
    private static final MarshallingInfo<StructuredPojo> METRIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metric").build();
    private static final MarshallingInfo<Integer> PERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Period").build();
    private static final MarshallingInfo<String> STAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Stat").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").build();
    private static final MetricStatMarshaller instance = new MetricStatMarshaller();

    public static MetricStatMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricStat metricStat, ProtocolMarshaller protocolMarshaller) {
        if (metricStat == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metricStat.getMetric(), METRIC_BINDING);
            protocolMarshaller.marshall((Object)metricStat.getPeriod(), PERIOD_BINDING);
            protocolMarshaller.marshall((Object)metricStat.getStat(), STAT_BINDING);
            protocolMarshaller.marshall((Object)metricStat.getUnit(), UNIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

