/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatch.model.Datapoint;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class DatapointMarshaller {
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Double> SAMPLECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampleCount").build();
    private static final MarshallingInfo<Double> AVERAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Average").build();
    private static final MarshallingInfo<Double> SUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sum").build();
    private static final MarshallingInfo<Double> MINIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Minimum").build();
    private static final MarshallingInfo<Double> MAXIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Maximum").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").build();
    private static final MarshallingInfo<Map> EXTENDEDSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtendedStatistics").build();
    private static final DatapointMarshaller instance = new DatapointMarshaller();

    public static DatapointMarshaller getInstance() {
        return instance;
    }

    public void marshall(Datapoint datapoint, ProtocolMarshaller protocolMarshaller) {
        if (datapoint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)datapoint.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)datapoint.getSampleCount(), SAMPLECOUNT_BINDING);
            protocolMarshaller.marshall((Object)datapoint.getAverage(), AVERAGE_BINDING);
            protocolMarshaller.marshall((Object)datapoint.getSum(), SUM_BINDING);
            protocolMarshaller.marshall((Object)datapoint.getMinimum(), MINIMUM_BINDING);
            protocolMarshaller.marshall((Object)datapoint.getMaximum(), MAXIMUM_BINDING);
            protocolMarshaller.marshall((Object)datapoint.getUnit(), UNIT_BINDING);
            protocolMarshaller.marshall(datapoint.getExtendedStatistics(), EXTENDEDSTATISTICS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

