/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatch.model.CompositeAlarm;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class CompositeAlarmMarshaller {
    private static final MarshallingInfo<Boolean> ACTIONSENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionsEnabled").build();
    private static final MarshallingInfo<List> ALARMACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlarmActions").build();
    private static final MarshallingInfo<String> ALARMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlarmArn").build();
    private static final MarshallingInfo<Date> ALARMCONFIGURATIONUPDATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlarmConfigurationUpdatedTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ALARMDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlarmDescription").build();
    private static final MarshallingInfo<String> ALARMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlarmName").build();
    private static final MarshallingInfo<String> ALARMRULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlarmRule").build();
    private static final MarshallingInfo<List> INSUFFICIENTDATAACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InsufficientDataActions").build();
    private static final MarshallingInfo<List> OKACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OKActions").build();
    private static final MarshallingInfo<String> STATEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateReason").build();
    private static final MarshallingInfo<String> STATEREASONDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateReasonData").build();
    private static final MarshallingInfo<Date> STATEUPDATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateUpdatedTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATEVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateValue").build();
    private static final MarshallingInfo<Date> STATETRANSITIONEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateTransitionedTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ACTIONSSUPPRESSEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionsSuppressedBy").build();
    private static final MarshallingInfo<String> ACTIONSSUPPRESSEDREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionsSuppressedReason").build();
    private static final MarshallingInfo<String> ACTIONSSUPPRESSOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionsSuppressor").build();
    private static final MarshallingInfo<Integer> ACTIONSSUPPRESSORWAITPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionsSuppressorWaitPeriod").build();
    private static final MarshallingInfo<Integer> ACTIONSSUPPRESSOREXTENSIONPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionsSuppressorExtensionPeriod").build();
    private static final CompositeAlarmMarshaller instance = new CompositeAlarmMarshaller();

    public static CompositeAlarmMarshaller getInstance() {
        return instance;
    }

    public void marshall(CompositeAlarm compositeAlarm, ProtocolMarshaller protocolMarshaller) {
        if (compositeAlarm == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)compositeAlarm.getActionsEnabled(), ACTIONSENABLED_BINDING);
            if (compositeAlarm.getAlarmActions() != null && !compositeAlarm.getAlarmActions().isEmpty()) {
                protocolMarshaller.marshall(compositeAlarm.getAlarmActions(), ALARMACTIONS_BINDING);
            }
            protocolMarshaller.marshall((Object)compositeAlarm.getAlarmArn(), ALARMARN_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getAlarmConfigurationUpdatedTimestamp(), ALARMCONFIGURATIONUPDATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getAlarmDescription(), ALARMDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getAlarmName(), ALARMNAME_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getAlarmRule(), ALARMRULE_BINDING);
            if (compositeAlarm.getInsufficientDataActions() != null && !compositeAlarm.getInsufficientDataActions().isEmpty()) {
                protocolMarshaller.marshall(compositeAlarm.getInsufficientDataActions(), INSUFFICIENTDATAACTIONS_BINDING);
            }
            if (compositeAlarm.getOKActions() != null && !compositeAlarm.getOKActions().isEmpty()) {
                protocolMarshaller.marshall(compositeAlarm.getOKActions(), OKACTIONS_BINDING);
            }
            protocolMarshaller.marshall((Object)compositeAlarm.getStateReason(), STATEREASON_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getStateReasonData(), STATEREASONDATA_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getStateUpdatedTimestamp(), STATEUPDATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getStateValue(), STATEVALUE_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getStateTransitionedTimestamp(), STATETRANSITIONEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getActionsSuppressedBy(), ACTIONSSUPPRESSEDBY_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getActionsSuppressedReason(), ACTIONSSUPPRESSEDREASON_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getActionsSuppressor(), ACTIONSSUPPRESSOR_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getActionsSuppressorWaitPeriod(), ACTIONSSUPPRESSORWAITPERIOD_BINDING);
            protocolMarshaller.marshall((Object)compositeAlarm.getActionsSuppressorExtensionPeriod(), ACTIONSSUPPRESSOREXTENSIONPERIOD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

