/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatch.model.AnomalyDetectorConfiguration;
import java.util.List;

@SdkInternalApi
public class AnomalyDetectorConfigurationMarshaller {
    private static final MarshallingInfo<List> EXCLUDEDTIMERANGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludedTimeRanges").build();
    private static final MarshallingInfo<String> METRICTIMEZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricTimezone").build();
    private static final AnomalyDetectorConfigurationMarshaller instance = new AnomalyDetectorConfigurationMarshaller();

    public static AnomalyDetectorConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(AnomalyDetectorConfiguration anomalyDetectorConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (anomalyDetectorConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            if (anomalyDetectorConfiguration.getExcludedTimeRanges() != null && !anomalyDetectorConfiguration.getExcludedTimeRanges().isEmpty()) {
                protocolMarshaller.marshall(anomalyDetectorConfiguration.getExcludedTimeRanges(), EXCLUDEDTIMERANGES_BINDING);
            }
            protocolMarshaller.marshall((Object)anomalyDetectorConfiguration.getMetricTimezone(), METRICTIMEZONE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

