/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudwatch.model.*;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/**
 * StopMetricStreamsRequest Marshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StopMetricStreamsRequestMarshaller implements Marshaller<Request<StopMetricStreamsRequest>, StopMetricStreamsRequest> {

    public Request<StopMetricStreamsRequest> marshall(StopMetricStreamsRequest stopMetricStreamsRequest) {

        if (stopMetricStreamsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<StopMetricStreamsRequest> request = new DefaultRequest<StopMetricStreamsRequest>(stopMetricStreamsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "StopMetricStreams");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (!stopMetricStreamsRequest.getNames().isEmpty()
                || !((com.amazonaws.internal.SdkInternalList<String>) stopMetricStreamsRequest.getNames()).isAutoConstruct()) {
            com.amazonaws.internal.SdkInternalList<String> namesList = (com.amazonaws.internal.SdkInternalList<String>) stopMetricStreamsRequest.getNames();
            int namesListIndex = 1;

            for (String namesListValue : namesList) {
                if (namesListValue != null) {
                    request.addParameter("Names.member." + namesListIndex, StringUtils.fromString(namesListValue));
                }
                namesListIndex++;
            }
        }

        return request;
    }

}
