/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest;
import com.amazonaws.services.cloudwatch.model.transform.DeleteAlarmsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmHistoryRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmHistoryResultStaxUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmsForMetricRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmsForMetricResultStaxUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DescribeAlarmsResultStaxUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.DisableAlarmActionsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.EnableAlarmActionsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.GetMetricStatisticsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.GetMetricStatisticsResultStaxUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InvalidFormatExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InvalidParameterCombinationExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.ListMetricsRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.ListMetricsResultStaxUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.MissingRequiredParameterExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.PutMetricAlarmRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.PutMetricDataRequestMarshaller;
import com.amazonaws.services.cloudwatch.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudwatch.model.transform.SetAlarmStateRequestMarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class AmazonCloudWatchClient
extends AmazonWebServiceClient
implements AmazonCloudWatch {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCloudWatch.class);
    private static final String DEFAULT_SIGNING_NAME = "monitoring";
    private static final String DEFAULT_ENDPOINT_PREFIX = "monitoring";
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AmazonCloudWatchClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonCloudWatchClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCloudWatchClient(AWSCredentials awsCredentials) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonCloudWatchClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCloudWatchClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonCloudWatchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonCloudWatchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidFormatExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new MissingRequiredParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InternalServiceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidParameterCombinationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller());
        this.setEndpoint("https://monitoring.us-east-1.amazonaws.com");
        this.setServiceNameIntern("monitoring");
        this.setEndpointPrefix("monitoring");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudwatch/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudwatch/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAlarms(DeleteAlarmsRequest deleteAlarmsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAlarmsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAlarmsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAlarmsRequestMarshaller().marshall(deleteAlarmsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler(null);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlarmHistoryResult describeAlarmHistory(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAlarmHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAlarmHistoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAlarmHistoryRequestMarshaller().marshall(describeAlarmHistoryRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAlarmHistoryResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeAlarmHistoryResult describeAlarmHistoryResult = (DescribeAlarmHistoryResult)response.getAwsResponse();
            return describeAlarmHistoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAlarmHistoryResult describeAlarmHistory() {
        return this.describeAlarmHistory(new DescribeAlarmHistoryRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlarmsResult describeAlarms(DescribeAlarmsRequest describeAlarmsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAlarmsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAlarmsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAlarmsRequestMarshaller().marshall(describeAlarmsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAlarmsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeAlarmsResult describeAlarmsResult = (DescribeAlarmsResult)response.getAwsResponse();
            return describeAlarmsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAlarmsResult describeAlarms() {
        return this.describeAlarms(new DescribeAlarmsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlarmsForMetricResult describeAlarmsForMetric(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAlarmsForMetricRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAlarmsForMetricRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAlarmsForMetricRequestMarshaller().marshall(describeAlarmsForMetricRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAlarmsForMetricResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeAlarmsForMetricResult describeAlarmsForMetricResult = (DescribeAlarmsForMetricResult)response.getAwsResponse();
            return describeAlarmsForMetricResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableAlarmActions(DisableAlarmActionsRequest disableAlarmActionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableAlarmActionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableAlarmActionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableAlarmActionsRequestMarshaller().marshall(disableAlarmActionsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler(null);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableAlarmActions(EnableAlarmActionsRequest enableAlarmActionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableAlarmActionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableAlarmActionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableAlarmActionsRequestMarshaller().marshall(enableAlarmActionsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler(null);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMetricStatisticsResult getMetricStatistics(GetMetricStatisticsRequest getMetricStatisticsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMetricStatisticsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMetricStatisticsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMetricStatisticsRequestMarshaller().marshall(getMetricStatisticsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetMetricStatisticsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetMetricStatisticsResult getMetricStatisticsResult = (GetMetricStatisticsResult)response.getAwsResponse();
            return getMetricStatisticsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMetricsResult listMetrics(ListMetricsRequest listMetricsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMetricsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMetricsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMetricsRequestMarshaller().marshall(listMetricsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListMetricsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListMetricsResult listMetricsResult = (ListMetricsResult)response.getAwsResponse();
            return listMetricsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMetricsResult listMetrics() {
        return this.listMetrics(new ListMetricsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putMetricAlarm(PutMetricAlarmRequest putMetricAlarmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putMetricAlarmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutMetricAlarmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutMetricAlarmRequestMarshaller().marshall(putMetricAlarmRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler(null);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putMetricData(PutMetricDataRequest putMetricDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putMetricDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutMetricDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutMetricDataRequestMarshaller().marshall(putMetricDataRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler(null);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAlarmState(SetAlarmStateRequest setAlarmStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setAlarmStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetAlarmStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetAlarmStateRequestMarshaller().marshall(setAlarmStateRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler(null);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

