/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.InsightSelector;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutInsightSelectorsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String trailName;
    private SdkInternalList<InsightSelector> insightSelectors;
    private String eventDataStore;
    private String insightsDestination;

    public void setTrailName(String trailName) {
        this.trailName = trailName;
    }

    public String getTrailName() {
        return this.trailName;
    }

    public PutInsightSelectorsRequest withTrailName(String trailName) {
        this.setTrailName(trailName);
        return this;
    }

    public List<InsightSelector> getInsightSelectors() {
        if (this.insightSelectors == null) {
            this.insightSelectors = new SdkInternalList();
        }
        return this.insightSelectors;
    }

    public void setInsightSelectors(Collection<InsightSelector> insightSelectors) {
        if (insightSelectors == null) {
            this.insightSelectors = null;
            return;
        }
        this.insightSelectors = new SdkInternalList(insightSelectors);
    }

    public PutInsightSelectorsRequest withInsightSelectors(InsightSelector ... insightSelectors) {
        if (this.insightSelectors == null) {
            this.setInsightSelectors((Collection<InsightSelector>)new SdkInternalList(insightSelectors.length));
        }
        for (InsightSelector ele : insightSelectors) {
            this.insightSelectors.add((Object)ele);
        }
        return this;
    }

    public PutInsightSelectorsRequest withInsightSelectors(Collection<InsightSelector> insightSelectors) {
        this.setInsightSelectors(insightSelectors);
        return this;
    }

    public void setEventDataStore(String eventDataStore) {
        this.eventDataStore = eventDataStore;
    }

    public String getEventDataStore() {
        return this.eventDataStore;
    }

    public PutInsightSelectorsRequest withEventDataStore(String eventDataStore) {
        this.setEventDataStore(eventDataStore);
        return this;
    }

    public void setInsightsDestination(String insightsDestination) {
        this.insightsDestination = insightsDestination;
    }

    public String getInsightsDestination() {
        return this.insightsDestination;
    }

    public PutInsightSelectorsRequest withInsightsDestination(String insightsDestination) {
        this.setInsightsDestination(insightsDestination);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrailName() != null) {
            sb.append("TrailName: ").append(this.getTrailName()).append(",");
        }
        if (this.getInsightSelectors() != null) {
            sb.append("InsightSelectors: ").append(this.getInsightSelectors()).append(",");
        }
        if (this.getEventDataStore() != null) {
            sb.append("EventDataStore: ").append(this.getEventDataStore()).append(",");
        }
        if (this.getInsightsDestination() != null) {
            sb.append("InsightsDestination: ").append(this.getInsightsDestination());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInsightSelectorsRequest)) {
            return false;
        }
        PutInsightSelectorsRequest other = (PutInsightSelectorsRequest)obj;
        if (other.getTrailName() == null ^ this.getTrailName() == null) {
            return false;
        }
        if (other.getTrailName() != null && !other.getTrailName().equals(this.getTrailName())) {
            return false;
        }
        if (other.getInsightSelectors() == null ^ this.getInsightSelectors() == null) {
            return false;
        }
        if (other.getInsightSelectors() != null && !other.getInsightSelectors().equals(this.getInsightSelectors())) {
            return false;
        }
        if (other.getEventDataStore() == null ^ this.getEventDataStore() == null) {
            return false;
        }
        if (other.getEventDataStore() != null && !other.getEventDataStore().equals(this.getEventDataStore())) {
            return false;
        }
        if (other.getInsightsDestination() == null ^ this.getInsightsDestination() == null) {
            return false;
        }
        return other.getInsightsDestination() == null || other.getInsightsDestination().equals(this.getInsightsDestination());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrailName() == null ? 0 : this.getTrailName().hashCode());
        hashCode = 31 * hashCode + (this.getInsightSelectors() == null ? 0 : this.getInsightSelectors().hashCode());
        hashCode = 31 * hashCode + (this.getEventDataStore() == null ? 0 : this.getEventDataStore().hashCode());
        hashCode = 31 * hashCode + (this.getInsightsDestination() == null ? 0 : this.getInsightsDestination().hashCode());
        return hashCode;
    }

    public PutInsightSelectorsRequest clone() {
        return (PutInsightSelectorsRequest)super.clone();
    }
}

