/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.services.cloudtrail.model.DataResource;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class DataResourceJsonUnmarshaller
implements Unmarshaller<DataResource, JsonUnmarshallerContext> {
    private static DataResourceJsonUnmarshaller instance;

    public DataResource unmarshall(JsonUnmarshallerContext context) throws Exception {
        DataResource dataResource = new DataResource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    dataResource.setType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Values", targetDepth)) {
                    context.nextToken();
                    dataResource.setValues(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return dataResource;
    }

    public static DataResourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DataResourceJsonUnmarshaller();
        }
        return instance;
    }
}

