/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudtrail.model.DataResource;

public class DataResourceJsonMarshaller {
    private static DataResourceJsonMarshaller instance;

    public void marshall(DataResource dataResource, StructuredJsonGenerator jsonGenerator) {
        if (dataResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList valuesList;
            jsonGenerator.writeStartObject();
            if (dataResource.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(dataResource.getType());
            }
            if (!(valuesList = (SdkInternalList)dataResource.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Values");
                jsonGenerator.writeStartArray();
                for (String valuesListValue : valuesList) {
                    if (valuesListValue == null) continue;
                    jsonGenerator.writeValue(valuesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DataResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DataResourceJsonMarshaller();
        }
        return instance;
    }
}

