/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudtrail.model.Resource;

public class ResourceJsonMarshaller {
    private static ResourceJsonMarshaller instance;

    public void marshall(Resource resource, StructuredJsonGenerator jsonGenerator) {
        if (resource == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (resource.getResourceType() != null) {
                jsonGenerator.writeFieldName("ResourceType").writeValue(resource.getResourceType());
            }
            if (resource.getResourceName() != null) {
                jsonGenerator.writeFieldName("ResourceName").writeValue(resource.getResourceName());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceJsonMarshaller();
        }
        return instance;
    }
}

