/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.RemoveTagsRequest;
import com.amazonaws.services.cloudtrail.model.Tag;
import com.amazonaws.services.cloudtrail.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RemoveTagsRequestMarshaller
implements Marshaller<Request<RemoveTagsRequest>, RemoveTagsRequest> {
    public Request<RemoveTagsRequest> marshall(RemoveTagsRequest removeTagsRequest) {
        if (removeTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removeTagsRequest, "AWSCloudTrail");
        request.addHeader("X-Amz-Target", "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101.RemoveTags");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagsListList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (removeTagsRequest.getResourceId() != null) {
                jsonGenerator.writeFieldName("ResourceId").writeValue(removeTagsRequest.getResourceId());
            }
            if (!(tagsListList = (SdkInternalList)removeTagsRequest.getTagsList()).isEmpty() || !tagsListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TagsList");
                jsonGenerator.writeStartArray();
                for (Tag tagsListListValue : tagsListList) {
                    if (tagsListListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

