/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.ResourceTag;
import com.amazonaws.services.cloudtrail.model.Tag;
import com.amazonaws.services.cloudtrail.model.transform.TagJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class ResourceTagJsonMarshaller {
    private static ResourceTagJsonMarshaller instance;

    public void marshall(ResourceTag resourceTag, SdkJsonGenerator jsonGenerator) {
        if (resourceTag == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList tagsListList;
            jsonGenerator.writeStartObject();
            if (resourceTag.getResourceId() != null) {
                jsonGenerator.writeFieldName("ResourceId").writeValue(resourceTag.getResourceId());
            }
            if (!(tagsListList = (SdkInternalList)resourceTag.getTagsList()).isEmpty() || !tagsListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TagsList");
                jsonGenerator.writeStartArray();
                for (Tag tagsListListValue : tagsListList) {
                    if (tagsListListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResourceTagJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceTagJsonMarshaller();
        }
        return instance;
    }
}

