/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeTrailsRequestMarshaller
implements Marshaller<Request<DescribeTrailsRequest>, DescribeTrailsRequest> {
    public Request<DescribeTrailsRequest> marshall(DescribeTrailsRequest describeTrailsRequest) {
        if (describeTrailsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTrailsRequest, "AWSCloudTrail");
        request.addHeader("X-Amz-Target", "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101.DescribeTrails");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList trailNameListList = (SdkInternalList)describeTrailsRequest.getTrailNameList();
            if (!trailNameListList.isEmpty() || !trailNameListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("trailNameList");
                jsonGenerator.writeStartArray();
                for (String trailNameListListValue : trailNameListList) {
                    if (trailNameListListValue == null) continue;
                    jsonGenerator.writeValue(trailNameListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeTrailsRequest.getIncludeShadowTrails() != null) {
                jsonGenerator.writeFieldName("includeShadowTrails").writeValue(describeTrailsRequest.getIncludeShadowTrails().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

