/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudtrail.model.UpdateTrailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateTrailRequestMarshaller
implements Marshaller<Request<UpdateTrailRequest>, UpdateTrailRequest> {
    public Request<UpdateTrailRequest> marshall(UpdateTrailRequest updateTrailRequest) {
        if (updateTrailRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateTrailRequest, "AWSCloudTrail");
        String target = "CloudTrail_20131101.UpdateTrail";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateTrailRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)updateTrailRequest.getName());
            }
            if (updateTrailRequest.getS3BucketName() != null) {
                jsonWriter.key("S3BucketName").value((Object)updateTrailRequest.getS3BucketName());
            }
            if (updateTrailRequest.getS3KeyPrefix() != null) {
                jsonWriter.key("S3KeyPrefix").value((Object)updateTrailRequest.getS3KeyPrefix());
            }
            if (updateTrailRequest.getSnsTopicName() != null) {
                jsonWriter.key("SnsTopicName").value((Object)updateTrailRequest.getSnsTopicName());
            }
            if (updateTrailRequest.isIncludeGlobalServiceEvents() != null) {
                jsonWriter.key("IncludeGlobalServiceEvents").value((Object)updateTrailRequest.isIncludeGlobalServiceEvents());
            }
            if (updateTrailRequest.isEnableLogFileValidation() != null) {
                jsonWriter.key("EnableLogFileValidation").value((Object)updateTrailRequest.isEnableLogFileValidation());
            }
            if (updateTrailRequest.getCloudWatchLogsLogGroupArn() != null) {
                jsonWriter.key("CloudWatchLogsLogGroupArn").value((Object)updateTrailRequest.getCloudWatchLogsLogGroupArn());
            }
            if (updateTrailRequest.getCloudWatchLogsRoleArn() != null) {
                jsonWriter.key("CloudWatchLogsRoleArn").value((Object)updateTrailRequest.getCloudWatchLogsRoleArn());
            }
            if (updateTrailRequest.getKmsKeyId() != null) {
                jsonWriter.key("KmsKeyId").value((Object)updateTrailRequest.getKmsKeyId());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

