/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudsearchdomain.AmazonCloudSearchDomainAsync;
import com.amazonaws.services.cloudsearchdomain.AmazonCloudSearchDomainClient;
import com.amazonaws.services.cloudsearchdomain.model.SearchRequest;
import com.amazonaws.services.cloudsearchdomain.model.SearchResult;
import com.amazonaws.services.cloudsearchdomain.model.SuggestRequest;
import com.amazonaws.services.cloudsearchdomain.model.SuggestResult;
import com.amazonaws.services.cloudsearchdomain.model.UploadDocumentsRequest;
import com.amazonaws.services.cloudsearchdomain.model.UploadDocumentsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonCloudSearchDomainAsyncClient
extends AmazonCloudSearchDomainClient
implements AmazonCloudSearchDomainAsync {
    private final ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonCloudSearchDomainAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCloudSearchDomainAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudSearchDomainAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudSearchDomainAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonCloudSearchDomainAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCloudSearchDomainAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudSearchDomainAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonCloudSearchDomainAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudSearchDomainAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<UploadDocumentsResult> uploadDocumentsAsync(final UploadDocumentsRequest uploadDocumentsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UploadDocumentsResult>(){

            @Override
            public UploadDocumentsResult call() throws Exception {
                return AmazonCloudSearchDomainAsyncClient.this.uploadDocuments(uploadDocumentsRequest);
            }
        });
    }

    @Override
    public Future<UploadDocumentsResult> uploadDocumentsAsync(final UploadDocumentsRequest uploadDocumentsRequest, final AsyncHandler<UploadDocumentsRequest, UploadDocumentsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UploadDocumentsResult>(){

            @Override
            public UploadDocumentsResult call() throws Exception {
                UploadDocumentsResult result;
                try {
                    result = AmazonCloudSearchDomainAsyncClient.this.uploadDocuments(uploadDocumentsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)uploadDocumentsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<SuggestResult> suggestAsync(final SuggestRequest suggestRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SuggestResult>(){

            @Override
            public SuggestResult call() throws Exception {
                return AmazonCloudSearchDomainAsyncClient.this.suggest(suggestRequest);
            }
        });
    }

    @Override
    public Future<SuggestResult> suggestAsync(final SuggestRequest suggestRequest, final AsyncHandler<SuggestRequest, SuggestResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SuggestResult>(){

            @Override
            public SuggestResult call() throws Exception {
                SuggestResult result;
                try {
                    result = AmazonCloudSearchDomainAsyncClient.this.suggest(suggestRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)suggestRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<SearchResult> searchAsync(final SearchRequest searchRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SearchResult>(){

            @Override
            public SearchResult call() throws Exception {
                return AmazonCloudSearchDomainAsyncClient.this.search(searchRequest);
            }
        });
    }

    @Override
    public Future<SearchResult> searchAsync(final SearchRequest searchRequest, final AsyncHandler<SearchRequest, SearchResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SearchResult>(){

            @Override
            public SearchResult call() throws Exception {
                SearchResult result;
                try {
                    result = AmazonCloudSearchDomainAsyncClient.this.search(searchRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)searchRequest, (Object)result);
                return result;
            }
        });
    }
}

