/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudhsm.model.CreateLunaClientRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateLunaClientRequestMarshaller
implements Marshaller<Request<CreateLunaClientRequest>, CreateLunaClientRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateLunaClientRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateLunaClientRequest> marshall(CreateLunaClientRequest createLunaClientRequest) {
        if (createLunaClientRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLunaClientRequest, "AWSCloudHSM");
        request.addHeader("X-Amz-Target", "CloudHsmFrontendService.CreateLunaClient");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createLunaClientRequest.getLabel() != null) {
                jsonGenerator.writeFieldName("Label").writeValue(createLunaClientRequest.getLabel());
            }
            if (createLunaClientRequest.getCertificate() != null) {
                jsonGenerator.writeFieldName("Certificate").writeValue(createLunaClientRequest.getCertificate());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

