/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudhsm.model.ModifyHapgRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ModifyHapgRequestMarshaller
implements Marshaller<Request<ModifyHapgRequest>, ModifyHapgRequest> {
    public Request<ModifyHapgRequest> marshall(ModifyHapgRequest modifyHapgRequest) {
        if (modifyHapgRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyHapgRequest, "AWSCloudHSM");
        String target = "CloudHsmFrontendService.ModifyHapg";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag partitionSerialListList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (modifyHapgRequest.getHapgArn() != null) {
                jsonWriter.key("HapgArn").value((Object)modifyHapgRequest.getHapgArn());
            }
            if (modifyHapgRequest.getLabel() != null) {
                jsonWriter.key("Label").value((Object)modifyHapgRequest.getLabel());
            }
            if (!((partitionSerialListList = (ListWithAutoConstructFlag)modifyHapgRequest.getPartitionSerialList()) == null || partitionSerialListList.isAutoConstruct() && partitionSerialListList.isEmpty())) {
                jsonWriter.key("PartitionSerialList");
                jsonWriter.array();
                for (String partitionSerialListListValue : partitionSerialListList) {
                    if (partitionSerialListListValue == null) continue;
                    jsonWriter.value((Object)partitionSerialListListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

