/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.GetInvalidationRequest;
import com.amazonaws.transform.Marshaller;

public class GetInvalidationRequestMarshaller
implements Marshaller<Request<GetInvalidationRequest>, GetInvalidationRequest> {
    public Request<GetInvalidationRequest> marshall(GetInvalidationRequest getInvalidationRequest) {
        if (getInvalidationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getInvalidationRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "2014-11-06/distribution/{DistributionId}/invalidation/{Id}";
        uriResourcePath = uriResourcePath.replace("{DistributionId}", this.getString(getInvalidationRequest.getDistributionId()));
        uriResourcePath = uriResourcePath.replace("{Id}", this.getString(getInvalidationRequest.getId()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

