/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.FunctionConfig;
import com.amazonaws.services.cloudfront.model.transform.KeyValueStoreAssociationsStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class FunctionConfigStaxUnmarshaller
implements Unmarshaller<FunctionConfig, StaxUnmarshallerContext> {
    private static FunctionConfigStaxUnmarshaller instance;

    public FunctionConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        FunctionConfig functionConfig = new FunctionConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return functionConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Comment", targetDepth)) {
                    functionConfig.setComment(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Runtime", targetDepth)) {
                    functionConfig.setRuntime(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("KeyValueStoreAssociations", targetDepth)) continue;
                functionConfig.setKeyValueStoreAssociations(KeyValueStoreAssociationsStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return functionConfig;
    }

    public static FunctionConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FunctionConfigStaxUnmarshaller();
        }
        return instance;
    }
}

