/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.FunctionMetadata;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class FunctionMetadataStaxUnmarshaller
implements Unmarshaller<FunctionMetadata, StaxUnmarshallerContext> {
    private static FunctionMetadataStaxUnmarshaller instance;

    public FunctionMetadata unmarshall(StaxUnmarshallerContext context) throws Exception {
        FunctionMetadata functionMetadata = new FunctionMetadata();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return functionMetadata;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("FunctionARN", targetDepth)) {
                    functionMetadata.setFunctionARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Stage", targetDepth)) {
                    functionMetadata.setStage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    functionMetadata.setCreatedTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (!context.testExpression("LastModifiedTime", targetDepth)) continue;
                functionMetadata.setLastModifiedTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return functionMetadata;
    }

    public static FunctionMetadataStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FunctionMetadataStaxUnmarshaller();
        }
        return instance;
    }
}

