/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.EndPoint;
import com.amazonaws.services.cloudfront.model.RealtimeLogConfig;
import com.amazonaws.services.cloudfront.model.transform.EndPointStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class RealtimeLogConfigStaxUnmarshaller
implements Unmarshaller<RealtimeLogConfig, StaxUnmarshallerContext> {
    private static RealtimeLogConfigStaxUnmarshaller instance;

    public RealtimeLogConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        RealtimeLogConfig realtimeLogConfig = new RealtimeLogConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return realtimeLogConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ARN", targetDepth)) {
                    realtimeLogConfig.setARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Name", targetDepth)) {
                    realtimeLogConfig.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SamplingRate", targetDepth)) {
                    realtimeLogConfig.setSamplingRate(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EndPoints", targetDepth)) {
                    realtimeLogConfig.withEndPoints(new ArrayList<EndPoint>());
                    continue;
                }
                if (context.testExpression("EndPoints/member", targetDepth)) {
                    realtimeLogConfig.withEndPoints(EndPointStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Fields", targetDepth)) {
                    realtimeLogConfig.withFields(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Fields/Field", targetDepth)) continue;
                realtimeLogConfig.withFields(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return realtimeLogConfig;
    }

    public static RealtimeLogConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RealtimeLogConfigStaxUnmarshaller();
        }
        return instance;
    }
}

