/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.AssociateAliasRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class AssociateAliasRequestMarshaller
implements Marshaller<Request<AssociateAliasRequest>, AssociateAliasRequest> {
    public Request<AssociateAliasRequest> marshall(AssociateAliasRequest associateAliasRequest) {
        if (associateAliasRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)associateAliasRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2020-05-31/distribution/{TargetDistributionId}/associate-alias";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "TargetDistributionId", associateAliasRequest.getTargetDistributionId());
        request.setResourcePath(uriResourcePath);
        if (associateAliasRequest.getAlias() != null) {
            request.addParameter("Alias", StringUtils.fromString((String)associateAliasRequest.getAlias()));
        }
        return request;
    }
}

