/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;

public class DeleteStreamingDistributionRequestMarshaller
implements Marshaller<Request<DeleteStreamingDistributionRequest>, DeleteStreamingDistributionRequest> {
    public Request<DeleteStreamingDistributionRequest> marshall(DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) {
        if (deleteStreamingDistributionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteStreamingDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteStreamingDistributionRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)deleteStreamingDistributionRequest.getIfMatch()));
        }
        String uriResourcePath = "/2016-01-28/streaming-distribution/{Id}";
        uriResourcePath = uriResourcePath.replace("{Id}", deleteStreamingDistributionRequest.getId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteStreamingDistributionRequest.getId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

