/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.Aliases;
import com.amazonaws.services.cloudfront.model.S3Origin;
import com.amazonaws.services.cloudfront.model.StreamingDistributionConfig;
import com.amazonaws.services.cloudfront.model.StreamingLoggingConfig;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateStreamingDistributionRequestMarshaller
implements Marshaller<Request<UpdateStreamingDistributionRequest>, UpdateStreamingDistributionRequest> {
    public Request<UpdateStreamingDistributionRequest> marshall(UpdateStreamingDistributionRequest updateStreamingDistributionRequest) {
        if (updateStreamingDistributionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateStreamingDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateStreamingDistributionRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)updateStreamingDistributionRequest.getIfMatch()));
        }
        String uriResourcePath = "/2016-09-29/streaming-distribution/{Id}/config";
        uriResourcePath = uriResourcePath.replace("{Id}", updateStreamingDistributionRequest.getId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)updateStreamingDistributionRequest.getId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2016-09-29/");
            StreamingDistributionConfig streamingDistributionConfig = updateStreamingDistributionRequest.getStreamingDistributionConfig();
            if (streamingDistributionConfig != null) {
                TrustedSigners trustedSigners;
                StreamingLoggingConfig logging;
                Aliases aliases;
                S3Origin s3Origin;
                xmlWriter.startElement("StreamingDistributionConfig");
                if (streamingDistributionConfig.getCallerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(streamingDistributionConfig.getCallerReference()).endElement();
                }
                if ((s3Origin = streamingDistributionConfig.getS3Origin()) != null) {
                    xmlWriter.startElement("S3Origin");
                    if (s3Origin.getDomainName() != null) {
                        xmlWriter.startElement("DomainName").value(s3Origin.getDomainName()).endElement();
                    }
                    if (s3Origin.getOriginAccessIdentity() != null) {
                        xmlWriter.startElement("OriginAccessIdentity").value(s3Origin.getOriginAccessIdentity()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((aliases = streamingDistributionConfig.getAliases()) != null) {
                    SdkInternalList aliasesItemsList;
                    xmlWriter.startElement("Aliases");
                    if (aliases.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)aliases.getQuantity()).endElement();
                    }
                    if (!(aliasesItemsList = (SdkInternalList)aliases.getItems()).isEmpty() || !aliasesItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (String aliasesItemsListValue : aliasesItemsList) {
                            xmlWriter.startElement("CNAME");
                            xmlWriter.value(aliasesItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (streamingDistributionConfig.getComment() != null) {
                    xmlWriter.startElement("Comment").value(streamingDistributionConfig.getComment()).endElement();
                }
                if ((logging = streamingDistributionConfig.getLogging()) != null) {
                    xmlWriter.startElement("Logging");
                    if (logging.getEnabled() != null) {
                        xmlWriter.startElement("Enabled").value((Object)logging.getEnabled()).endElement();
                    }
                    if (logging.getBucket() != null) {
                        xmlWriter.startElement("Bucket").value(logging.getBucket()).endElement();
                    }
                    if (logging.getPrefix() != null) {
                        xmlWriter.startElement("Prefix").value(logging.getPrefix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((trustedSigners = streamingDistributionConfig.getTrustedSigners()) != null) {
                    SdkInternalList trustedSignersItemsList;
                    xmlWriter.startElement("TrustedSigners");
                    if (trustedSigners.getEnabled() != null) {
                        xmlWriter.startElement("Enabled").value((Object)trustedSigners.getEnabled()).endElement();
                    }
                    if (trustedSigners.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)trustedSigners.getQuantity()).endElement();
                    }
                    if (!(trustedSignersItemsList = (SdkInternalList)trustedSigners.getItems()).isEmpty() || !trustedSignersItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (String trustedSignersItemsListValue : trustedSignersItemsList) {
                            xmlWriter.startElement("AwsAccountNumber");
                            xmlWriter.value(trustedSignersItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (streamingDistributionConfig.getPriceClass() != null) {
                    xmlWriter.startElement("PriceClass").value(streamingDistributionConfig.getPriceClass()).endElement();
                }
                if (streamingDistributionConfig.getEnabled() != null) {
                    xmlWriter.startElement("Enabled").value((Object)streamingDistributionConfig.getEnabled()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

