/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.ListStackSetOperationResultsRequest;
import com.amazonaws.services.cloudformation.model.OperationResultFilter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListStackSetOperationResultsRequestMarshaller
implements Marshaller<Request<ListStackSetOperationResultsRequest>, ListStackSetOperationResultsRequest> {
    public Request<ListStackSetOperationResultsRequest> marshall(ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) {
        if (listStackSetOperationResultsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listStackSetOperationResultsRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ListStackSetOperationResults");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStackSetOperationResultsRequest.getStackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)listStackSetOperationResultsRequest.getStackSetName()));
        }
        if (listStackSetOperationResultsRequest.getOperationId() != null) {
            request.addParameter("OperationId", StringUtils.fromString((String)listStackSetOperationResultsRequest.getOperationId()));
        }
        if (listStackSetOperationResultsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listStackSetOperationResultsRequest.getNextToken()));
        }
        if (listStackSetOperationResultsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)listStackSetOperationResultsRequest.getMaxResults()));
        }
        if (listStackSetOperationResultsRequest.getCallAs() != null) {
            request.addParameter("CallAs", StringUtils.fromString((String)listStackSetOperationResultsRequest.getCallAs()));
        }
        if (listStackSetOperationResultsRequest.getFilters().isEmpty() && !((SdkInternalList)listStackSetOperationResultsRequest.getFilters()).isAutoConstruct()) {
            request.addParameter("Filters", "");
        }
        if (!listStackSetOperationResultsRequest.getFilters().isEmpty() || !((SdkInternalList)listStackSetOperationResultsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)listStackSetOperationResultsRequest.getFilters();
            int filtersListIndex = 1;
            for (OperationResultFilter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.member." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (filtersListValue.getValues() != null) {
                        request.addParameter("Filters.member." + filtersListIndex + ".Values", StringUtils.fromString((String)filtersListValue.getValues()));
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

