/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudformation.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * The structure that contains information about a stack set operation.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSetOperation" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StackSetOperation implements Serializable, Cloneable {

    /**
     * <p>
     * The unique ID of a stack set operation.
     * </p>
     */
    private String operationId;
    /**
     * <p>
     * The ID of the stack set.
     * </p>
     */
    private String stackSetId;
    /**
     * <p>
     * The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and
     * delete operations affect only the specified stack set instances that are associated with the specified stack set.
     * Update operations affect both the stack set itself, in addition to <i>all</i> associated stack set instances.
     * </p>
     */
    private String action;
    /**
     * <p>
     * The status of the operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that
     * you've set for an operation is applied for each Region during stack create and update operations. If the number
     * of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set
     * to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and
     * CloudFormation cancels the operation in any remaining Regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of
     * operations, the operation is queued to be performed. For more information, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes"
     * >stack set operation status codes</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation is currently being performed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code>: The user has canceled the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding
     * the failure tolerance for the operation.
     * </p>
     * </li>
     * </ul>
     */
    private String status;
    /**
     * <p>
     * The preferences for how CloudFormation performs this stack set operation.
     * </p>
     */
    private StackSetOperationPreferences operationPreferences;
    /**
     * <p>
     * For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack instances from
     * the specified stack set, but doesn't delete the stacks. You can't re-associate a retained stack, or add an
     * existing, saved stack to a new stack set.
     * </p>
     */
    private Boolean retainStacks;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used to perform this stack set operation.
     * </p>
     * <p>
     * Use customized administrator roles to control which users or groups can manage specific stack sets within the
     * same administrator account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Define Permissions
     * for Multiple Administrators</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     */
    private String administrationRoleARN;
    /**
     * <p>
     * The name of the IAM execution role used to create or update the stack set.
     * </p>
     * <p>
     * Use customized execution roles to control which stack resources users and groups can include in their stack sets.
     * </p>
     */
    private String executionRoleName;
    /**
     * <p>
     * The time at which the operation was initiated. Note that the creation times for the stack set operation might
     * differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to
     * perform preparatory work for the operation, such as dispatching the work to the requested Regions, before
     * actually creating the first stacks.
     * </p>
     */
    private java.util.Date creationTimestamp;
    /**
     * <p>
     * The time at which the stack set operation ended, across all accounts and Regions specified. Note that this
     * doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or
     * Region.
     * </p>
     */
    private java.util.Date endTimestamp;
    /**
     * <p>
     * [Service-managed permissions] The Organizations accounts affected by the stack operation.
     * </p>
     */
    private DeploymentTargets deploymentTargets;
    /**
     * <p>
     * Detailed information about the drift status of the stack set. This includes information about drift operations
     * currently being performed on the stack set.
     * </p>
     * <p>
     * This information will only be present for stack set operations whose <code>Action</code> type is
     * <code>DETECT_DRIFT</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged
     * Changes in Stack Sets</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     */
    private StackSetDriftDetectionDetails stackSetDriftDetectionDetails;
    /**
     * <p>
     * The status of the operation in details.
     * </p>
     */
    private String statusReason;
    /**
     * <p>
     * Detailed information about the StackSet operation.
     * </p>
     */
    private StackSetOperationStatusDetails statusDetails;

    /**
     * <p>
     * The unique ID of a stack set operation.
     * </p>
     * 
     * @param operationId
     *        The unique ID of a stack set operation.
     */

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    /**
     * <p>
     * The unique ID of a stack set operation.
     * </p>
     * 
     * @return The unique ID of a stack set operation.
     */

    public String getOperationId() {
        return this.operationId;
    }

    /**
     * <p>
     * The unique ID of a stack set operation.
     * </p>
     * 
     * @param operationId
     *        The unique ID of a stack set operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StackSetOperation withOperationId(String operationId) {
        setOperationId(operationId);
        return this;
    }

    /**
     * <p>
     * The ID of the stack set.
     * </p>
     * 
     * @param stackSetId
     *        The ID of the stack set.
     */

    public void setStackSetId(String stackSetId) {
        this.stackSetId = stackSetId;
    }

    /**
     * <p>
     * The ID of the stack set.
     * </p>
     * 
     * @return The ID of the stack set.
     */

    public String getStackSetId() {
        return this.stackSetId;
    }

    /**
     * <p>
     * The ID of the stack set.
     * </p>
     * 
     * @param stackSetId
     *        The ID of the stack set.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StackSetOperation withStackSetId(String stackSetId) {
        setStackSetId(stackSetId);
        return this;
    }

    /**
     * <p>
     * The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and
     * delete operations affect only the specified stack set instances that are associated with the specified stack set.
     * Update operations affect both the stack set itself, in addition to <i>all</i> associated stack set instances.
     * </p>
     * 
     * @param action
     *        The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create
     *        and delete operations affect only the specified stack set instances that are associated with the specified
     *        stack set. Update operations affect both the stack set itself, in addition to <i>all</i> associated stack
     *        set instances.
     * @see StackSetOperationAction
     */

    public void setAction(String action) {
        this.action = action;
    }

    /**
     * <p>
     * The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and
     * delete operations affect only the specified stack set instances that are associated with the specified stack set.
     * Update operations affect both the stack set itself, in addition to <i>all</i> associated stack set instances.
     * </p>
     * 
     * @return The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create
     *         and delete operations affect only the specified stack set instances that are associated with the
     *         specified stack set. Update operations affect both the stack set itself, in addition to <i>all</i>
     *         associated stack set instances.
     * @see StackSetOperationAction
     */

    public String getAction() {
        return this.action;
    }

    /**
     * <p>
     * The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and
     * delete operations affect only the specified stack set instances that are associated with the specified stack set.
     * Update operations affect both the stack set itself, in addition to <i>all</i> associated stack set instances.
     * </p>
     * 
     * @param action
     *        The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create
     *        and delete operations affect only the specified stack set instances that are associated with the specified
     *        stack set. Update operations affect both the stack set itself, in addition to <i>all</i> associated stack
     *        set instances.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StackSetOperationAction
     */

    public StackSetOperation withAction(String action) {
        setAction(action);
        return this;
    }

    /**
     * <p>
     * The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and
     * delete operations affect only the specified stack set instances that are associated with the specified stack set.
     * Update operations affect both the stack set itself, in addition to <i>all</i> associated stack set instances.
     * </p>
     * 
     * @param action
     *        The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create
     *        and delete operations affect only the specified stack set instances that are associated with the specified
     *        stack set. Update operations affect both the stack set itself, in addition to <i>all</i> associated stack
     *        set instances.
     * @see StackSetOperationAction
     */

    public void setAction(StackSetOperationAction action) {
        withAction(action);
    }

    /**
     * <p>
     * The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and
     * delete operations affect only the specified stack set instances that are associated with the specified stack set.
     * Update operations affect both the stack set itself, in addition to <i>all</i> associated stack set instances.
     * </p>
     * 
     * @param action
     *        The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create
     *        and delete operations affect only the specified stack set instances that are associated with the specified
     *        stack set. Update operations affect both the stack set itself, in addition to <i>all</i> associated stack
     *        set instances.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StackSetOperationAction
     */

    public StackSetOperation withAction(StackSetOperationAction action) {
        this.action = action.toString();
        return this;
    }

    /**
     * <p>
     * The status of the operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that
     * you've set for an operation is applied for each Region during stack create and update operations. If the number
     * of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set
     * to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and
     * CloudFormation cancels the operation in any remaining Regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of
     * operations, the operation is queued to be performed. For more information, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes"
     * >stack set operation status codes</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation is currently being performed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code>: The user has canceled the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding
     * the failure tolerance for the operation.
     * </p>
     * </li>
     * </ul>
     * 
     * @param status
     *        The status of the operation.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value
     *        that you've set for an operation is applied for each Region during stack create and update operations. If
     *        the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in
     *        the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to
     *        <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of
     *        operations, the operation is queued to be performed. For more information, see the <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes"
     *        >stack set operation status codes</a> in the <i>CloudFormation User Guide</i>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>RUNNING</code>: The operation is currently being performed.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>STOPPED</code>: The user has canceled the operation.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without
     *        exceeding the failure tolerance for the operation.
     *        </p>
     *        </li>
     * @see StackSetOperationStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of the operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that
     * you've set for an operation is applied for each Region during stack create and update operations. If the number
     * of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set
     * to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and
     * CloudFormation cancels the operation in any remaining Regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of
     * operations, the operation is queued to be performed. For more information, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes"
     * >stack set operation status codes</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation is currently being performed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code>: The user has canceled the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding
     * the failure tolerance for the operation.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the operation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value
     *         that you've set for an operation is applied for each Region during stack create and update operations. If
     *         the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in
     *         the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to
     *         <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of
     *         operations, the operation is queued to be performed. For more information, see the <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes"
     *         >stack set operation status codes</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: The operation is currently being performed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code>: The user has canceled the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without
     *         exceeding the failure tolerance for the operation.
     *         </p>
     *         </li>
     * @see StackSetOperationStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of the operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that
     * you've set for an operation is applied for each Region during stack create and update operations. If the number
     * of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set
     * to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and
     * CloudFormation cancels the operation in any remaining Regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of
     * operations, the operation is queued to be performed. For more information, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes"
     * >stack set operation status codes</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation is currently being performed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code>: The user has canceled the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding
     * the failure tolerance for the operation.
     * </p>
     * </li>
     * </ul>
     * 
     * @param status
     *        The status of the operation.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value
     *        that you've set for an operation is applied for each Region during stack create and update operations. If
     *        the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in
     *        the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to
     *        <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of
     *        operations, the operation is queued to be performed. For more information, see the <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes"
     *        >stack set operation status codes</a> in the <i>CloudFormation User Guide</i>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>RUNNING</code>: The operation is currently being performed.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>STOPPED</code>: The user has canceled the operation.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without
     *        exceeding the failure tolerance for the operation.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StackSetOperationStatus
     */

    public StackSetOperation withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The status of the operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that
     * you've set for an operation is applied for each Region during stack create and update operations. If the number
     * of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set
     * to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and
     * CloudFormation cancels the operation in any remaining Regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of
     * operations, the operation is queued to be performed. For more information, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes"
     * >stack set operation status codes</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation is currently being performed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code>: The user has canceled the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding
     * the failure tolerance for the operation.
     * </p>
     * </li>
     * </ul>
     * 
     * @param status
     *        The status of the operation.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value
     *        that you've set for an operation is applied for each Region during stack create and update operations. If
     *        the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in
     *        the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to
     *        <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of
     *        operations, the operation is queued to be performed. For more information, see the <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes"
     *        >stack set operation status codes</a> in the <i>CloudFormation User Guide</i>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>RUNNING</code>: The operation is currently being performed.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>STOPPED</code>: The user has canceled the operation.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without
     *        exceeding the failure tolerance for the operation.
     *        </p>
     *        </li>
     * @see StackSetOperationStatus
     */

    public void setStatus(StackSetOperationStatus status) {
        withStatus(status);
    }

    /**
     * <p>
     * The status of the operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that
     * you've set for an operation is applied for each Region during stack create and update operations. If the number
     * of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set
     * to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and
     * CloudFormation cancels the operation in any remaining Regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of
     * operations, the operation is queued to be performed. For more information, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes"
     * >stack set operation status codes</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation is currently being performed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code>: The user has canceled the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding
     * the failure tolerance for the operation.
     * </p>
     * </li>
     * </ul>
     * 
     * @param status
     *        The status of the operation.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value
     *        that you've set for an operation is applied for each Region during stack create and update operations. If
     *        the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in
     *        the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to
     *        <code>FAILED</code>, and CloudFormation cancels the operation in any remaining Regions.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>QUEUED</code>: [Service-managed permissions] For automatic deployments that require a sequence of
     *        operations, the operation is queued to be performed. For more information, see the <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes"
     *        >stack set operation status codes</a> in the <i>CloudFormation User Guide</i>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>RUNNING</code>: The operation is currently being performed.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>STOPPED</code>: The user has canceled the operation.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>STOPPING</code>: The operation is in the process of stopping, at user request.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without
     *        exceeding the failure tolerance for the operation.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StackSetOperationStatus
     */

    public StackSetOperation withStatus(StackSetOperationStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * The preferences for how CloudFormation performs this stack set operation.
     * </p>
     * 
     * @param operationPreferences
     *        The preferences for how CloudFormation performs this stack set operation.
     */

    public void setOperationPreferences(StackSetOperationPreferences operationPreferences) {
        this.operationPreferences = operationPreferences;
    }

    /**
     * <p>
     * The preferences for how CloudFormation performs this stack set operation.
     * </p>
     * 
     * @return The preferences for how CloudFormation performs this stack set operation.
     */

    public StackSetOperationPreferences getOperationPreferences() {
        return this.operationPreferences;
    }

    /**
     * <p>
     * The preferences for how CloudFormation performs this stack set operation.
     * </p>
     * 
     * @param operationPreferences
     *        The preferences for how CloudFormation performs this stack set operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StackSetOperation withOperationPreferences(StackSetOperationPreferences operationPreferences) {
        setOperationPreferences(operationPreferences);
        return this;
    }

    /**
     * <p>
     * For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack instances from
     * the specified stack set, but doesn't delete the stacks. You can't re-associate a retained stack, or add an
     * existing, saved stack to a new stack set.
     * </p>
     * 
     * @param retainStacks
     *        For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack
     *        instances from the specified stack set, but doesn't delete the stacks. You can't re-associate a retained
     *        stack, or add an existing, saved stack to a new stack set.
     */

    public void setRetainStacks(Boolean retainStacks) {
        this.retainStacks = retainStacks;
    }

    /**
     * <p>
     * For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack instances from
     * the specified stack set, but doesn't delete the stacks. You can't re-associate a retained stack, or add an
     * existing, saved stack to a new stack set.
     * </p>
     * 
     * @return For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack
     *         instances from the specified stack set, but doesn't delete the stacks. You can't re-associate a retained
     *         stack, or add an existing, saved stack to a new stack set.
     */

    public Boolean getRetainStacks() {
        return this.retainStacks;
    }

    /**
     * <p>
     * For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack instances from
     * the specified stack set, but doesn't delete the stacks. You can't re-associate a retained stack, or add an
     * existing, saved stack to a new stack set.
     * </p>
     * 
     * @param retainStacks
     *        For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack
     *        instances from the specified stack set, but doesn't delete the stacks. You can't re-associate a retained
     *        stack, or add an existing, saved stack to a new stack set.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StackSetOperation withRetainStacks(Boolean retainStacks) {
        setRetainStacks(retainStacks);
        return this;
    }

    /**
     * <p>
     * For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack instances from
     * the specified stack set, but doesn't delete the stacks. You can't re-associate a retained stack, or add an
     * existing, saved stack to a new stack set.
     * </p>
     * 
     * @return For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack
     *         instances from the specified stack set, but doesn't delete the stacks. You can't re-associate a retained
     *         stack, or add an existing, saved stack to a new stack set.
     */

    public Boolean isRetainStacks() {
        return this.retainStacks;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used to perform this stack set operation.
     * </p>
     * <p>
     * Use customized administrator roles to control which users or groups can manage specific stack sets within the
     * same administrator account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Define Permissions
     * for Multiple Administrators</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @param administrationRoleARN
     *        The Amazon Resource Name (ARN) of the IAM role used to perform this stack set operation.</p>
     *        <p>
     *        Use customized administrator roles to control which users or groups can manage specific stack sets within
     *        the same administrator account. For more information, see <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Define
     *        Permissions for Multiple Administrators</a> in the <i>CloudFormation User Guide</i>.
     */

    public void setAdministrationRoleARN(String administrationRoleARN) {
        this.administrationRoleARN = administrationRoleARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used to perform this stack set operation.
     * </p>
     * <p>
     * Use customized administrator roles to control which users or groups can manage specific stack sets within the
     * same administrator account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Define Permissions
     * for Multiple Administrators</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used to perform this stack set operation.</p>
     *         <p>
     *         Use customized administrator roles to control which users or groups can manage specific stack sets within
     *         the same administrator account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Define
     *         Permissions for Multiple Administrators</a> in the <i>CloudFormation User Guide</i>.
     */

    public String getAdministrationRoleARN() {
        return this.administrationRoleARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used to perform this stack set operation.
     * </p>
     * <p>
     * Use customized administrator roles to control which users or groups can manage specific stack sets within the
     * same administrator account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Define Permissions
     * for Multiple Administrators</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @param administrationRoleARN
     *        The Amazon Resource Name (ARN) of the IAM role used to perform this stack set operation.</p>
     *        <p>
     *        Use customized administrator roles to control which users or groups can manage specific stack sets within
     *        the same administrator account. For more information, see <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Define
     *        Permissions for Multiple Administrators</a> in the <i>CloudFormation User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StackSetOperation withAdministrationRoleARN(String administrationRoleARN) {
        setAdministrationRoleARN(administrationRoleARN);
        return this;
    }

    /**
     * <p>
     * The name of the IAM execution role used to create or update the stack set.
     * </p>
     * <p>
     * Use customized execution roles to control which stack resources users and groups can include in their stack sets.
     * </p>
     * 
     * @param executionRoleName
     *        The name of the IAM execution role used to create or update the stack set.</p>
     *        <p>
     *        Use customized execution roles to control which stack resources users and groups can include in their
     *        stack sets.
     */

    public void setExecutionRoleName(String executionRoleName) {
        this.executionRoleName = executionRoleName;
    }

    /**
     * <p>
     * The name of the IAM execution role used to create or update the stack set.
     * </p>
     * <p>
     * Use customized execution roles to control which stack resources users and groups can include in their stack sets.
     * </p>
     * 
     * @return The name of the IAM execution role used to create or update the stack set.</p>
     *         <p>
     *         Use customized execution roles to control which stack resources users and groups can include in their
     *         stack sets.
     */

    public String getExecutionRoleName() {
        return this.executionRoleName;
    }

    /**
     * <p>
     * The name of the IAM execution role used to create or update the stack set.
     * </p>
     * <p>
     * Use customized execution roles to control which stack resources users and groups can include in their stack sets.
     * </p>
     * 
     * @param executionRoleName
     *        The name of the IAM execution role used to create or update the stack set.</p>
     *        <p>
     *        Use customized execution roles to control which stack resources users and groups can include in their
     *        stack sets.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StackSetOperation withExecutionRoleName(String executionRoleName) {
        setExecutionRoleName(executionRoleName);
        return this;
    }

    /**
     * <p>
     * The time at which the operation was initiated. Note that the creation times for the stack set operation might
     * differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to
     * perform preparatory work for the operation, such as dispatching the work to the requested Regions, before
     * actually creating the first stacks.
     * </p>
     * 
     * @param creationTimestamp
     *        The time at which the operation was initiated. Note that the creation times for the stack set operation
     *        might differ from the creation time of the individual stacks themselves. This is because CloudFormation
     *        needs to perform preparatory work for the operation, such as dispatching the work to the requested
     *        Regions, before actually creating the first stacks.
     */

    public void setCreationTimestamp(java.util.Date creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    /**
     * <p>
     * The time at which the operation was initiated. Note that the creation times for the stack set operation might
     * differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to
     * perform preparatory work for the operation, such as dispatching the work to the requested Regions, before
     * actually creating the first stacks.
     * </p>
     * 
     * @return The time at which the operation was initiated. Note that the creation times for the stack set operation
     *         might differ from the creation time of the individual stacks themselves. This is because CloudFormation
     *         needs to perform preparatory work for the operation, such as dispatching the work to the requested
     *         Regions, before actually creating the first stacks.
     */

    public java.util.Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    /**
     * <p>
     * The time at which the operation was initiated. Note that the creation times for the stack set operation might
     * differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to
     * perform preparatory work for the operation, such as dispatching the work to the requested Regions, before
     * actually creating the first stacks.
     * </p>
     * 
     * @param creationTimestamp
     *        The time at which the operation was initiated. Note that the creation times for the stack set operation
     *        might differ from the creation time of the individual stacks themselves. This is because CloudFormation
     *        needs to perform preparatory work for the operation, such as dispatching the work to the requested
     *        Regions, before actually creating the first stacks.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StackSetOperation withCreationTimestamp(java.util.Date creationTimestamp) {
        setCreationTimestamp(creationTimestamp);
        return this;
    }

    /**
     * <p>
     * The time at which the stack set operation ended, across all accounts and Regions specified. Note that this
     * doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or
     * Region.
     * </p>
     * 
     * @param endTimestamp
     *        The time at which the stack set operation ended, across all accounts and Regions specified. Note that this
     *        doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account
     *        or Region.
     */

    public void setEndTimestamp(java.util.Date endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    /**
     * <p>
     * The time at which the stack set operation ended, across all accounts and Regions specified. Note that this
     * doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or
     * Region.
     * </p>
     * 
     * @return The time at which the stack set operation ended, across all accounts and Regions specified. Note that
     *         this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each
     *         account or Region.
     */

    public java.util.Date getEndTimestamp() {
        return this.endTimestamp;
    }

    /**
     * <p>
     * The time at which the stack set operation ended, across all accounts and Regions specified. Note that this
     * doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or
     * Region.
     * </p>
     * 
     * @param endTimestamp
     *        The time at which the stack set operation ended, across all accounts and Regions specified. Note that this
     *        doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account
     *        or Region.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StackSetOperation withEndTimestamp(java.util.Date endTimestamp) {
        setEndTimestamp(endTimestamp);
        return this;
    }

    /**
     * <p>
     * [Service-managed permissions] The Organizations accounts affected by the stack operation.
     * </p>
     * 
     * @param deploymentTargets
     *        [Service-managed permissions] The Organizations accounts affected by the stack operation.
     */

    public void setDeploymentTargets(DeploymentTargets deploymentTargets) {
        this.deploymentTargets = deploymentTargets;
    }

    /**
     * <p>
     * [Service-managed permissions] The Organizations accounts affected by the stack operation.
     * </p>
     * 
     * @return [Service-managed permissions] The Organizations accounts affected by the stack operation.
     */

    public DeploymentTargets getDeploymentTargets() {
        return this.deploymentTargets;
    }

    /**
     * <p>
     * [Service-managed permissions] The Organizations accounts affected by the stack operation.
     * </p>
     * 
     * @param deploymentTargets
     *        [Service-managed permissions] The Organizations accounts affected by the stack operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StackSetOperation withDeploymentTargets(DeploymentTargets deploymentTargets) {
        setDeploymentTargets(deploymentTargets);
        return this;
    }

    /**
     * <p>
     * Detailed information about the drift status of the stack set. This includes information about drift operations
     * currently being performed on the stack set.
     * </p>
     * <p>
     * This information will only be present for stack set operations whose <code>Action</code> type is
     * <code>DETECT_DRIFT</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged
     * Changes in Stack Sets</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @param stackSetDriftDetectionDetails
     *        Detailed information about the drift status of the stack set. This includes information about drift
     *        operations currently being performed on the stack set.</p>
     *        <p>
     *        This information will only be present for stack set operations whose <code>Action</code> type is
     *        <code>DETECT_DRIFT</code>.
     *        </p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting
     *        Unmanaged Changes in Stack Sets</a> in the <i>CloudFormation User Guide</i>.
     */

    public void setStackSetDriftDetectionDetails(StackSetDriftDetectionDetails stackSetDriftDetectionDetails) {
        this.stackSetDriftDetectionDetails = stackSetDriftDetectionDetails;
    }

    /**
     * <p>
     * Detailed information about the drift status of the stack set. This includes information about drift operations
     * currently being performed on the stack set.
     * </p>
     * <p>
     * This information will only be present for stack set operations whose <code>Action</code> type is
     * <code>DETECT_DRIFT</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged
     * Changes in Stack Sets</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return Detailed information about the drift status of the stack set. This includes information about drift
     *         operations currently being performed on the stack set.</p>
     *         <p>
     *         This information will only be present for stack set operations whose <code>Action</code> type is
     *         <code>DETECT_DRIFT</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting
     *         Unmanaged Changes in Stack Sets</a> in the <i>CloudFormation User Guide</i>.
     */

    public StackSetDriftDetectionDetails getStackSetDriftDetectionDetails() {
        return this.stackSetDriftDetectionDetails;
    }

    /**
     * <p>
     * Detailed information about the drift status of the stack set. This includes information about drift operations
     * currently being performed on the stack set.
     * </p>
     * <p>
     * This information will only be present for stack set operations whose <code>Action</code> type is
     * <code>DETECT_DRIFT</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged
     * Changes in Stack Sets</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @param stackSetDriftDetectionDetails
     *        Detailed information about the drift status of the stack set. This includes information about drift
     *        operations currently being performed on the stack set.</p>
     *        <p>
     *        This information will only be present for stack set operations whose <code>Action</code> type is
     *        <code>DETECT_DRIFT</code>.
     *        </p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting
     *        Unmanaged Changes in Stack Sets</a> in the <i>CloudFormation User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StackSetOperation withStackSetDriftDetectionDetails(StackSetDriftDetectionDetails stackSetDriftDetectionDetails) {
        setStackSetDriftDetectionDetails(stackSetDriftDetectionDetails);
        return this;
    }

    /**
     * <p>
     * The status of the operation in details.
     * </p>
     * 
     * @param statusReason
     *        The status of the operation in details.
     */

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    /**
     * <p>
     * The status of the operation in details.
     * </p>
     * 
     * @return The status of the operation in details.
     */

    public String getStatusReason() {
        return this.statusReason;
    }

    /**
     * <p>
     * The status of the operation in details.
     * </p>
     * 
     * @param statusReason
     *        The status of the operation in details.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StackSetOperation withStatusReason(String statusReason) {
        setStatusReason(statusReason);
        return this;
    }

    /**
     * <p>
     * Detailed information about the StackSet operation.
     * </p>
     * 
     * @param statusDetails
     *        Detailed information about the StackSet operation.
     */

    public void setStatusDetails(StackSetOperationStatusDetails statusDetails) {
        this.statusDetails = statusDetails;
    }

    /**
     * <p>
     * Detailed information about the StackSet operation.
     * </p>
     * 
     * @return Detailed information about the StackSet operation.
     */

    public StackSetOperationStatusDetails getStatusDetails() {
        return this.statusDetails;
    }

    /**
     * <p>
     * Detailed information about the StackSet operation.
     * </p>
     * 
     * @param statusDetails
     *        Detailed information about the StackSet operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StackSetOperation withStatusDetails(StackSetOperationStatusDetails statusDetails) {
        setStatusDetails(statusDetails);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getOperationId() != null)
            sb.append("OperationId: ").append(getOperationId()).append(",");
        if (getStackSetId() != null)
            sb.append("StackSetId: ").append(getStackSetId()).append(",");
        if (getAction() != null)
            sb.append("Action: ").append(getAction()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getOperationPreferences() != null)
            sb.append("OperationPreferences: ").append(getOperationPreferences()).append(",");
        if (getRetainStacks() != null)
            sb.append("RetainStacks: ").append(getRetainStacks()).append(",");
        if (getAdministrationRoleARN() != null)
            sb.append("AdministrationRoleARN: ").append(getAdministrationRoleARN()).append(",");
        if (getExecutionRoleName() != null)
            sb.append("ExecutionRoleName: ").append(getExecutionRoleName()).append(",");
        if (getCreationTimestamp() != null)
            sb.append("CreationTimestamp: ").append(getCreationTimestamp()).append(",");
        if (getEndTimestamp() != null)
            sb.append("EndTimestamp: ").append(getEndTimestamp()).append(",");
        if (getDeploymentTargets() != null)
            sb.append("DeploymentTargets: ").append(getDeploymentTargets()).append(",");
        if (getStackSetDriftDetectionDetails() != null)
            sb.append("StackSetDriftDetectionDetails: ").append(getStackSetDriftDetectionDetails()).append(",");
        if (getStatusReason() != null)
            sb.append("StatusReason: ").append(getStatusReason()).append(",");
        if (getStatusDetails() != null)
            sb.append("StatusDetails: ").append(getStatusDetails());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StackSetOperation == false)
            return false;
        StackSetOperation other = (StackSetOperation) obj;
        if (other.getOperationId() == null ^ this.getOperationId() == null)
            return false;
        if (other.getOperationId() != null && other.getOperationId().equals(this.getOperationId()) == false)
            return false;
        if (other.getStackSetId() == null ^ this.getStackSetId() == null)
            return false;
        if (other.getStackSetId() != null && other.getStackSetId().equals(this.getStackSetId()) == false)
            return false;
        if (other.getAction() == null ^ this.getAction() == null)
            return false;
        if (other.getAction() != null && other.getAction().equals(this.getAction()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getOperationPreferences() == null ^ this.getOperationPreferences() == null)
            return false;
        if (other.getOperationPreferences() != null && other.getOperationPreferences().equals(this.getOperationPreferences()) == false)
            return false;
        if (other.getRetainStacks() == null ^ this.getRetainStacks() == null)
            return false;
        if (other.getRetainStacks() != null && other.getRetainStacks().equals(this.getRetainStacks()) == false)
            return false;
        if (other.getAdministrationRoleARN() == null ^ this.getAdministrationRoleARN() == null)
            return false;
        if (other.getAdministrationRoleARN() != null && other.getAdministrationRoleARN().equals(this.getAdministrationRoleARN()) == false)
            return false;
        if (other.getExecutionRoleName() == null ^ this.getExecutionRoleName() == null)
            return false;
        if (other.getExecutionRoleName() != null && other.getExecutionRoleName().equals(this.getExecutionRoleName()) == false)
            return false;
        if (other.getCreationTimestamp() == null ^ this.getCreationTimestamp() == null)
            return false;
        if (other.getCreationTimestamp() != null && other.getCreationTimestamp().equals(this.getCreationTimestamp()) == false)
            return false;
        if (other.getEndTimestamp() == null ^ this.getEndTimestamp() == null)
            return false;
        if (other.getEndTimestamp() != null && other.getEndTimestamp().equals(this.getEndTimestamp()) == false)
            return false;
        if (other.getDeploymentTargets() == null ^ this.getDeploymentTargets() == null)
            return false;
        if (other.getDeploymentTargets() != null && other.getDeploymentTargets().equals(this.getDeploymentTargets()) == false)
            return false;
        if (other.getStackSetDriftDetectionDetails() == null ^ this.getStackSetDriftDetectionDetails() == null)
            return false;
        if (other.getStackSetDriftDetectionDetails() != null
                && other.getStackSetDriftDetectionDetails().equals(this.getStackSetDriftDetectionDetails()) == false)
            return false;
        if (other.getStatusReason() == null ^ this.getStatusReason() == null)
            return false;
        if (other.getStatusReason() != null && other.getStatusReason().equals(this.getStatusReason()) == false)
            return false;
        if (other.getStatusDetails() == null ^ this.getStatusDetails() == null)
            return false;
        if (other.getStatusDetails() != null && other.getStatusDetails().equals(this.getStatusDetails()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getOperationId() == null) ? 0 : getOperationId().hashCode());
        hashCode = prime * hashCode + ((getStackSetId() == null) ? 0 : getStackSetId().hashCode());
        hashCode = prime * hashCode + ((getAction() == null) ? 0 : getAction().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getOperationPreferences() == null) ? 0 : getOperationPreferences().hashCode());
        hashCode = prime * hashCode + ((getRetainStacks() == null) ? 0 : getRetainStacks().hashCode());
        hashCode = prime * hashCode + ((getAdministrationRoleARN() == null) ? 0 : getAdministrationRoleARN().hashCode());
        hashCode = prime * hashCode + ((getExecutionRoleName() == null) ? 0 : getExecutionRoleName().hashCode());
        hashCode = prime * hashCode + ((getCreationTimestamp() == null) ? 0 : getCreationTimestamp().hashCode());
        hashCode = prime * hashCode + ((getEndTimestamp() == null) ? 0 : getEndTimestamp().hashCode());
        hashCode = prime * hashCode + ((getDeploymentTargets() == null) ? 0 : getDeploymentTargets().hashCode());
        hashCode = prime * hashCode + ((getStackSetDriftDetectionDetails() == null) ? 0 : getStackSetDriftDetectionDetails().hashCode());
        hashCode = prime * hashCode + ((getStatusReason() == null) ? 0 : getStatusReason().hashCode());
        hashCode = prime * hashCode + ((getStatusDetails() == null) ? 0 : getStatusDetails().hashCode());
        return hashCode;
    }

    @Override
    public StackSetOperation clone() {
        try {
            return (StackSetOperation) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
