/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudformation.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeTypeRegistration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeTypeRegistrationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier for this registration request.
     * </p>
     * <p>
     * This registration token is generated by CloudFormation when you initiate a registration request using
     * <a>RegisterType</a>.
     * </p>
     */
    private String registrationToken;

    /**
     * <p>
     * The identifier for this registration request.
     * </p>
     * <p>
     * This registration token is generated by CloudFormation when you initiate a registration request using
     * <a>RegisterType</a>.
     * </p>
     * 
     * @param registrationToken
     *        The identifier for this registration request.</p>
     *        <p>
     *        This registration token is generated by CloudFormation when you initiate a registration request using
     *        <a>RegisterType</a>.
     */

    public void setRegistrationToken(String registrationToken) {
        this.registrationToken = registrationToken;
    }

    /**
     * <p>
     * The identifier for this registration request.
     * </p>
     * <p>
     * This registration token is generated by CloudFormation when you initiate a registration request using
     * <a>RegisterType</a>.
     * </p>
     * 
     * @return The identifier for this registration request.</p>
     *         <p>
     *         This registration token is generated by CloudFormation when you initiate a registration request using
     *         <a>RegisterType</a>.
     */

    public String getRegistrationToken() {
        return this.registrationToken;
    }

    /**
     * <p>
     * The identifier for this registration request.
     * </p>
     * <p>
     * This registration token is generated by CloudFormation when you initiate a registration request using
     * <a>RegisterType</a>.
     * </p>
     * 
     * @param registrationToken
     *        The identifier for this registration request.</p>
     *        <p>
     *        This registration token is generated by CloudFormation when you initiate a registration request using
     *        <a>RegisterType</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeTypeRegistrationRequest withRegistrationToken(String registrationToken) {
        setRegistrationToken(registrationToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRegistrationToken() != null)
            sb.append("RegistrationToken: ").append(getRegistrationToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeTypeRegistrationRequest == false)
            return false;
        DescribeTypeRegistrationRequest other = (DescribeTypeRegistrationRequest) obj;
        if (other.getRegistrationToken() == null ^ this.getRegistrationToken() == null)
            return false;
        if (other.getRegistrationToken() != null && other.getRegistrationToken().equals(this.getRegistrationToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRegistrationToken() == null) ? 0 : getRegistrationToken().hashCode());
        return hashCode;
    }

    @Override
    public DescribeTypeRegistrationRequest clone() {
        return (DescribeTypeRegistrationRequest) super.clone();
    }

}
