/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudformation.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.*;
import com.amazonaws.transform.Marshaller;

/**
 * ActivateOrganizationsAccessRequest Marshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ActivateOrganizationsAccessRequestMarshaller implements
        Marshaller<Request<ActivateOrganizationsAccessRequest>, ActivateOrganizationsAccessRequest> {

    public Request<ActivateOrganizationsAccessRequest> marshall(ActivateOrganizationsAccessRequest activateOrganizationsAccessRequest) {

        if (activateOrganizationsAccessRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ActivateOrganizationsAccessRequest> request = new DefaultRequest<ActivateOrganizationsAccessRequest>(activateOrganizationsAccessRequest,
                "AmazonCloudFormation");
        request.addParameter("Action", "ActivateOrganizationsAccess");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        return request;
    }

}
