/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.CreateStackInstancesRequest;
import com.amazonaws.services.cloudformation.model.DeploymentTargets;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.StackSetOperationPreferences;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateStackInstancesRequestMarshaller
implements Marshaller<Request<CreateStackInstancesRequest>, CreateStackInstancesRequest> {
    public Request<CreateStackInstancesRequest> marshall(CreateStackInstancesRequest createStackInstancesRequest) {
        StackSetOperationPreferences operationPreferences;
        DeploymentTargets deploymentTargets;
        if (createStackInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStackInstancesRequest, "AmazonCloudFormation");
        request.addParameter("Action", "CreateStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackInstancesRequest.getStackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)createStackInstancesRequest.getStackSetName()));
        }
        if (createStackInstancesRequest.getAccounts().isEmpty() && !((SdkInternalList)createStackInstancesRequest.getAccounts()).isAutoConstruct()) {
            request.addParameter("Accounts", "");
        }
        if (!createStackInstancesRequest.getAccounts().isEmpty() || !((SdkInternalList)createStackInstancesRequest.getAccounts()).isAutoConstruct()) {
            SdkInternalList accountsList = (SdkInternalList)createStackInstancesRequest.getAccounts();
            int accountsListIndex = 1;
            for (Object accountsListValue : accountsList) {
                if (accountsListValue != null) {
                    request.addParameter("Accounts.member." + accountsListIndex, StringUtils.fromString((String)accountsListValue));
                }
                ++accountsListIndex;
            }
        }
        if ((deploymentTargets = createStackInstancesRequest.getDeploymentTargets()) != null) {
            if (deploymentTargets.getAccounts().isEmpty() && !((SdkInternalList)deploymentTargets.getAccounts()).isAutoConstruct()) {
                request.addParameter("DeploymentTargets.Accounts", "");
            }
            if (!deploymentTargets.getAccounts().isEmpty() || !((SdkInternalList)deploymentTargets.getAccounts()).isAutoConstruct()) {
                SdkInternalList accountsList = (SdkInternalList)deploymentTargets.getAccounts();
                int accountsListIndex = 1;
                for (String accountsListValue : accountsList) {
                    if (accountsListValue != null) {
                        request.addParameter("DeploymentTargets.Accounts.member." + accountsListIndex, StringUtils.fromString((String)accountsListValue));
                    }
                    ++accountsListIndex;
                }
            }
            if (deploymentTargets.getAccountsUrl() != null) {
                request.addParameter("DeploymentTargets.AccountsUrl", StringUtils.fromString((String)deploymentTargets.getAccountsUrl()));
            }
            if (deploymentTargets.getOrganizationalUnitIds().isEmpty() && !((SdkInternalList)deploymentTargets.getOrganizationalUnitIds()).isAutoConstruct()) {
                request.addParameter("DeploymentTargets.OrganizationalUnitIds", "");
            }
            if (!deploymentTargets.getOrganizationalUnitIds().isEmpty() || !((SdkInternalList)deploymentTargets.getOrganizationalUnitIds()).isAutoConstruct()) {
                SdkInternalList organizationalUnitIdsList = (SdkInternalList)deploymentTargets.getOrganizationalUnitIds();
                int organizationalUnitIdsListIndex = 1;
                for (String organizationalUnitIdsListValue : organizationalUnitIdsList) {
                    if (organizationalUnitIdsListValue != null) {
                        request.addParameter("DeploymentTargets.OrganizationalUnitIds.member." + organizationalUnitIdsListIndex, StringUtils.fromString((String)organizationalUnitIdsListValue));
                    }
                    ++organizationalUnitIdsListIndex;
                }
            }
            if (deploymentTargets.getAccountFilterType() != null) {
                request.addParameter("DeploymentTargets.AccountFilterType", StringUtils.fromString((String)deploymentTargets.getAccountFilterType()));
            }
        }
        if (createStackInstancesRequest.getRegions().isEmpty() && !((SdkInternalList)createStackInstancesRequest.getRegions()).isAutoConstruct()) {
            request.addParameter("Regions", "");
        }
        if (!createStackInstancesRequest.getRegions().isEmpty() || !((SdkInternalList)createStackInstancesRequest.getRegions()).isAutoConstruct()) {
            SdkInternalList regionsList = (SdkInternalList)createStackInstancesRequest.getRegions();
            int regionsListIndex = 1;
            for (String regionsListValue : regionsList) {
                if (regionsListValue != null) {
                    request.addParameter("Regions.member." + regionsListIndex, StringUtils.fromString((String)regionsListValue));
                }
                ++regionsListIndex;
            }
        }
        if (createStackInstancesRequest.getParameterOverrides().isEmpty() && !((SdkInternalList)createStackInstancesRequest.getParameterOverrides()).isAutoConstruct()) {
            request.addParameter("ParameterOverrides", "");
        }
        if (!createStackInstancesRequest.getParameterOverrides().isEmpty() || !((SdkInternalList)createStackInstancesRequest.getParameterOverrides()).isAutoConstruct()) {
            SdkInternalList parameterOverridesList = (SdkInternalList)createStackInstancesRequest.getParameterOverrides();
            int parameterOverridesListIndex = 1;
            for (Parameter parameterOverridesListValue : parameterOverridesList) {
                if (parameterOverridesListValue != null) {
                    if (parameterOverridesListValue.getParameterKey() != null) {
                        request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".ParameterKey", StringUtils.fromString((String)parameterOverridesListValue.getParameterKey()));
                    }
                    if (parameterOverridesListValue.getParameterValue() != null) {
                        request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".ParameterValue", StringUtils.fromString((String)parameterOverridesListValue.getParameterValue()));
                    }
                    if (parameterOverridesListValue.getUsePreviousValue() != null) {
                        request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parameterOverridesListValue.getUsePreviousValue()));
                    }
                    if (parameterOverridesListValue.getResolvedValue() != null) {
                        request.addParameter("ParameterOverrides.member." + parameterOverridesListIndex + ".ResolvedValue", StringUtils.fromString((String)parameterOverridesListValue.getResolvedValue()));
                    }
                }
                ++parameterOverridesListIndex;
            }
        }
        if ((operationPreferences = createStackInstancesRequest.getOperationPreferences()) != null) {
            if (operationPreferences.getRegionConcurrencyType() != null) {
                request.addParameter("OperationPreferences.RegionConcurrencyType", StringUtils.fromString((String)operationPreferences.getRegionConcurrencyType()));
            }
            if (operationPreferences.getRegionOrder().isEmpty() && !((SdkInternalList)operationPreferences.getRegionOrder()).isAutoConstruct()) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            }
            if (!operationPreferences.getRegionOrder().isEmpty() || !((SdkInternalList)operationPreferences.getRegionOrder()).isAutoConstruct()) {
                SdkInternalList regionOrderList = (SdkInternalList)operationPreferences.getRegionOrder();
                int regionOrderListIndex = 1;
                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringUtils.fromString((String)regionOrderListValue));
                    }
                    ++regionOrderListIndex;
                }
            }
            if (operationPreferences.getFailureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringUtils.fromInteger((Integer)operationPreferences.getFailureToleranceCount()));
            }
            if (operationPreferences.getFailureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringUtils.fromInteger((Integer)operationPreferences.getFailureTolerancePercentage()));
            }
            if (operationPreferences.getMaxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringUtils.fromInteger((Integer)operationPreferences.getMaxConcurrentCount()));
            }
            if (operationPreferences.getMaxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringUtils.fromInteger((Integer)operationPreferences.getMaxConcurrentPercentage()));
            }
            if (operationPreferences.getConcurrencyMode() != null) {
                request.addParameter("OperationPreferences.ConcurrencyMode", StringUtils.fromString((String)operationPreferences.getConcurrencyMode()));
            }
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString((String)createStackInstancesRequest.getOperationId()));
        if (createStackInstancesRequest.getCallAs() != null) {
            request.addParameter("CallAs", StringUtils.fromString((String)createStackInstancesRequest.getCallAs()));
        }
        return request;
    }
}

