/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.AccountFilterType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DeploymentTargets
implements Serializable,
Cloneable {
    private SdkInternalList<String> accounts;
    private String accountsUrl;
    private SdkInternalList<String> organizationalUnitIds;
    private String accountFilterType;

    public List<String> getAccounts() {
        if (this.accounts == null) {
            this.accounts = new SdkInternalList();
        }
        return this.accounts;
    }

    public void setAccounts(Collection<String> accounts) {
        if (accounts == null) {
            this.accounts = null;
            return;
        }
        this.accounts = new SdkInternalList(accounts);
    }

    public DeploymentTargets withAccounts(String ... accounts) {
        if (this.accounts == null) {
            this.setAccounts((Collection<String>)new SdkInternalList(accounts.length));
        }
        for (String ele : accounts) {
            this.accounts.add((Object)ele);
        }
        return this;
    }

    public DeploymentTargets withAccounts(Collection<String> accounts) {
        this.setAccounts(accounts);
        return this;
    }

    public void setAccountsUrl(String accountsUrl) {
        this.accountsUrl = accountsUrl;
    }

    public String getAccountsUrl() {
        return this.accountsUrl;
    }

    public DeploymentTargets withAccountsUrl(String accountsUrl) {
        this.setAccountsUrl(accountsUrl);
        return this;
    }

    public List<String> getOrganizationalUnitIds() {
        if (this.organizationalUnitIds == null) {
            this.organizationalUnitIds = new SdkInternalList();
        }
        return this.organizationalUnitIds;
    }

    public void setOrganizationalUnitIds(Collection<String> organizationalUnitIds) {
        if (organizationalUnitIds == null) {
            this.organizationalUnitIds = null;
            return;
        }
        this.organizationalUnitIds = new SdkInternalList(organizationalUnitIds);
    }

    public DeploymentTargets withOrganizationalUnitIds(String ... organizationalUnitIds) {
        if (this.organizationalUnitIds == null) {
            this.setOrganizationalUnitIds((Collection<String>)new SdkInternalList(organizationalUnitIds.length));
        }
        for (String ele : organizationalUnitIds) {
            this.organizationalUnitIds.add((Object)ele);
        }
        return this;
    }

    public DeploymentTargets withOrganizationalUnitIds(Collection<String> organizationalUnitIds) {
        this.setOrganizationalUnitIds(organizationalUnitIds);
        return this;
    }

    public void setAccountFilterType(String accountFilterType) {
        this.accountFilterType = accountFilterType;
    }

    public String getAccountFilterType() {
        return this.accountFilterType;
    }

    public DeploymentTargets withAccountFilterType(String accountFilterType) {
        this.setAccountFilterType(accountFilterType);
        return this;
    }

    public DeploymentTargets withAccountFilterType(AccountFilterType accountFilterType) {
        this.accountFilterType = accountFilterType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccounts() != null) {
            sb.append("Accounts: ").append(this.getAccounts()).append(",");
        }
        if (this.getAccountsUrl() != null) {
            sb.append("AccountsUrl: ").append(this.getAccountsUrl()).append(",");
        }
        if (this.getOrganizationalUnitIds() != null) {
            sb.append("OrganizationalUnitIds: ").append(this.getOrganizationalUnitIds()).append(",");
        }
        if (this.getAccountFilterType() != null) {
            sb.append("AccountFilterType: ").append(this.getAccountFilterType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentTargets)) {
            return false;
        }
        DeploymentTargets other = (DeploymentTargets)obj;
        if (other.getAccounts() == null ^ this.getAccounts() == null) {
            return false;
        }
        if (other.getAccounts() != null && !other.getAccounts().equals(this.getAccounts())) {
            return false;
        }
        if (other.getAccountsUrl() == null ^ this.getAccountsUrl() == null) {
            return false;
        }
        if (other.getAccountsUrl() != null && !other.getAccountsUrl().equals(this.getAccountsUrl())) {
            return false;
        }
        if (other.getOrganizationalUnitIds() == null ^ this.getOrganizationalUnitIds() == null) {
            return false;
        }
        if (other.getOrganizationalUnitIds() != null && !other.getOrganizationalUnitIds().equals(this.getOrganizationalUnitIds())) {
            return false;
        }
        if (other.getAccountFilterType() == null ^ this.getAccountFilterType() == null) {
            return false;
        }
        return other.getAccountFilterType() == null || other.getAccountFilterType().equals(this.getAccountFilterType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccounts() == null ? 0 : this.getAccounts().hashCode());
        hashCode = 31 * hashCode + (this.getAccountsUrl() == null ? 0 : this.getAccountsUrl().hashCode());
        hashCode = 31 * hashCode + (this.getOrganizationalUnitIds() == null ? 0 : this.getOrganizationalUnitIds().hashCode());
        hashCode = 31 * hashCode + (this.getAccountFilterType() == null ? 0 : this.getAccountFilterType().hashCode());
        return hashCode;
    }

    public DeploymentTargets clone() {
        try {
            return (DeploymentTargets)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

