/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.CallAs;
import com.amazonaws.services.cloudformation.model.StackSetOperationPreferences;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ImportStacksToStackSetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String stackSetName;
    private SdkInternalList<String> stackIds;
    private StackSetOperationPreferences operationPreferences;
    private String operationId;
    private String callAs;

    public void setStackSetName(String stackSetName) {
        this.stackSetName = stackSetName;
    }

    public String getStackSetName() {
        return this.stackSetName;
    }

    public ImportStacksToStackSetRequest withStackSetName(String stackSetName) {
        this.setStackSetName(stackSetName);
        return this;
    }

    public List<String> getStackIds() {
        if (this.stackIds == null) {
            this.stackIds = new SdkInternalList();
        }
        return this.stackIds;
    }

    public void setStackIds(Collection<String> stackIds) {
        if (stackIds == null) {
            this.stackIds = null;
            return;
        }
        this.stackIds = new SdkInternalList(stackIds);
    }

    public ImportStacksToStackSetRequest withStackIds(String ... stackIds) {
        if (this.stackIds == null) {
            this.setStackIds((Collection<String>)new SdkInternalList(stackIds.length));
        }
        for (String ele : stackIds) {
            this.stackIds.add((Object)ele);
        }
        return this;
    }

    public ImportStacksToStackSetRequest withStackIds(Collection<String> stackIds) {
        this.setStackIds(stackIds);
        return this;
    }

    public void setOperationPreferences(StackSetOperationPreferences operationPreferences) {
        this.operationPreferences = operationPreferences;
    }

    public StackSetOperationPreferences getOperationPreferences() {
        return this.operationPreferences;
    }

    public ImportStacksToStackSetRequest withOperationPreferences(StackSetOperationPreferences operationPreferences) {
        this.setOperationPreferences(operationPreferences);
        return this;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public ImportStacksToStackSetRequest withOperationId(String operationId) {
        this.setOperationId(operationId);
        return this;
    }

    public void setCallAs(String callAs) {
        this.callAs = callAs;
    }

    public String getCallAs() {
        return this.callAs;
    }

    public ImportStacksToStackSetRequest withCallAs(String callAs) {
        this.setCallAs(callAs);
        return this;
    }

    public ImportStacksToStackSetRequest withCallAs(CallAs callAs) {
        this.callAs = callAs.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackSetName() != null) {
            sb.append("StackSetName: ").append(this.getStackSetName()).append(",");
        }
        if (this.getStackIds() != null) {
            sb.append("StackIds: ").append(this.getStackIds()).append(",");
        }
        if (this.getOperationPreferences() != null) {
            sb.append("OperationPreferences: ").append(this.getOperationPreferences()).append(",");
        }
        if (this.getOperationId() != null) {
            sb.append("OperationId: ").append(this.getOperationId()).append(",");
        }
        if (this.getCallAs() != null) {
            sb.append("CallAs: ").append(this.getCallAs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportStacksToStackSetRequest)) {
            return false;
        }
        ImportStacksToStackSetRequest other = (ImportStacksToStackSetRequest)obj;
        if (other.getStackSetName() == null ^ this.getStackSetName() == null) {
            return false;
        }
        if (other.getStackSetName() != null && !other.getStackSetName().equals(this.getStackSetName())) {
            return false;
        }
        if (other.getStackIds() == null ^ this.getStackIds() == null) {
            return false;
        }
        if (other.getStackIds() != null && !other.getStackIds().equals(this.getStackIds())) {
            return false;
        }
        if (other.getOperationPreferences() == null ^ this.getOperationPreferences() == null) {
            return false;
        }
        if (other.getOperationPreferences() != null && !other.getOperationPreferences().equals(this.getOperationPreferences())) {
            return false;
        }
        if (other.getOperationId() == null ^ this.getOperationId() == null) {
            return false;
        }
        if (other.getOperationId() != null && !other.getOperationId().equals(this.getOperationId())) {
            return false;
        }
        if (other.getCallAs() == null ^ this.getCallAs() == null) {
            return false;
        }
        return other.getCallAs() == null || other.getCallAs().equals(this.getCallAs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackSetName() == null ? 0 : this.getStackSetName().hashCode());
        hashCode = 31 * hashCode + (this.getStackIds() == null ? 0 : this.getStackIds().hashCode());
        hashCode = 31 * hashCode + (this.getOperationPreferences() == null ? 0 : this.getOperationPreferences().hashCode());
        hashCode = 31 * hashCode + (this.getOperationId() == null ? 0 : this.getOperationId().hashCode());
        hashCode = 31 * hashCode + (this.getCallAs() == null ? 0 : this.getCallAs().hashCode());
        return hashCode;
    }

    public ImportStacksToStackSetRequest clone() {
        return (ImportStacksToStackSetRequest)super.clone();
    }
}

