/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceDriftsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeStackResourceDriftsRequestMarshaller
implements Marshaller<Request<DescribeStackResourceDriftsRequest>, DescribeStackResourceDriftsRequest> {
    public Request<DescribeStackResourceDriftsRequest> marshall(DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest) {
        if (describeStackResourceDriftsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeStackResourceDriftsRequest, "AmazonCloudFormation");
        request.addParameter("Action", "DescribeStackResourceDrifts");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStackResourceDriftsRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)describeStackResourceDriftsRequest.getStackName()));
        }
        if (describeStackResourceDriftsRequest.getStackResourceDriftStatusFilters().isEmpty() && !((SdkInternalList)describeStackResourceDriftsRequest.getStackResourceDriftStatusFilters()).isAutoConstruct()) {
            request.addParameter("StackResourceDriftStatusFilters", "");
        }
        if (!describeStackResourceDriftsRequest.getStackResourceDriftStatusFilters().isEmpty() || !((SdkInternalList)describeStackResourceDriftsRequest.getStackResourceDriftStatusFilters()).isAutoConstruct()) {
            SdkInternalList stackResourceDriftStatusFiltersList = (SdkInternalList)describeStackResourceDriftsRequest.getStackResourceDriftStatusFilters();
            int stackResourceDriftStatusFiltersListIndex = 1;
            for (String stackResourceDriftStatusFiltersListValue : stackResourceDriftStatusFiltersList) {
                if (stackResourceDriftStatusFiltersListValue != null) {
                    request.addParameter("StackResourceDriftStatusFilters.member." + stackResourceDriftStatusFiltersListIndex, StringUtils.fromString((String)stackResourceDriftStatusFiltersListValue));
                }
                ++stackResourceDriftStatusFiltersListIndex;
            }
        }
        if (describeStackResourceDriftsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeStackResourceDriftsRequest.getNextToken()));
        }
        if (describeStackResourceDriftsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeStackResourceDriftsRequest.getMaxResults()));
        }
        return request;
    }
}

