/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.ListStackInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListStackInstancesRequestMarshaller
implements Marshaller<Request<ListStackInstancesRequest>, ListStackInstancesRequest> {
    public Request<ListStackInstancesRequest> marshall(ListStackInstancesRequest listStackInstancesRequest) {
        if (listStackInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listStackInstancesRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ListStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStackInstancesRequest.getStackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)listStackInstancesRequest.getStackSetName()));
        }
        if (listStackInstancesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listStackInstancesRequest.getNextToken()));
        }
        if (listStackInstancesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)listStackInstancesRequest.getMaxResults()));
        }
        if (listStackInstancesRequest.getStackInstanceAccount() != null) {
            request.addParameter("StackInstanceAccount", StringUtils.fromString((String)listStackInstancesRequest.getStackInstanceAccount()));
        }
        if (listStackInstancesRequest.getStackInstanceRegion() != null) {
            request.addParameter("StackInstanceRegion", StringUtils.fromString((String)listStackInstancesRequest.getStackInstanceRegion()));
        }
        return request;
    }
}

