/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.StackSet;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.services.cloudformation.model.transform.ParameterStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class StackSetStaxUnmarshaller
implements Unmarshaller<StackSet, StaxUnmarshallerContext> {
    private static StackSetStaxUnmarshaller instance;

    public StackSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        StackSet stackSet = new StackSet();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return stackSet;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StackSetName", targetDepth)) {
                    stackSet.setStackSetName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackSetId", targetDepth)) {
                    stackSet.setStackSetId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    stackSet.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    stackSet.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TemplateBody", targetDepth)) {
                    stackSet.setTemplateBody(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    stackSet.withParameters(new ArrayList<Parameter>());
                    continue;
                }
                if (context.testExpression("Parameters/member", targetDepth)) {
                    stackSet.withParameters(ParameterStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Capabilities", targetDepth)) {
                    stackSet.withCapabilities(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Capabilities/member", targetDepth)) {
                    stackSet.withCapabilities(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    stackSet.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("Tags/member", targetDepth)) {
                    stackSet.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackSetARN", targetDepth)) {
                    stackSet.setStackSetARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AdministrationRoleARN", targetDepth)) {
                    stackSet.setAdministrationRoleARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ExecutionRoleName", targetDepth)) continue;
                stackSet.setExecutionRoleName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return stackSet;
    }

    public static StackSetStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StackSetStaxUnmarshaller();
        }
        return instance;
    }
}

