/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudformation.AmazonCloudFormationAsync;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest;
import com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest;
import com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackResult;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeAccountLimitsRequest;
import com.amazonaws.services.cloudformation.model.DescribeAccountLimitsResult;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostResult;
import com.amazonaws.services.cloudformation.model.GetStackPolicyRequest;
import com.amazonaws.services.cloudformation.model.GetStackPolicyResult;
import com.amazonaws.services.cloudformation.model.GetTemplateRequest;
import com.amazonaws.services.cloudformation.model.GetTemplateResult;
import com.amazonaws.services.cloudformation.model.GetTemplateSummaryRequest;
import com.amazonaws.services.cloudformation.model.GetTemplateSummaryResult;
import com.amazonaws.services.cloudformation.model.ListStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.ListStackResourcesResult;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.services.cloudformation.model.ListStacksResult;
import com.amazonaws.services.cloudformation.model.SetStackPolicyRequest;
import com.amazonaws.services.cloudformation.model.SignalResourceRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import com.amazonaws.services.cloudformation.model.ValidateTemplateRequest;
import com.amazonaws.services.cloudformation.model.ValidateTemplateResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCloudFormationAsyncClient
extends AmazonCloudFormationClient
implements AmazonCloudFormationAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonCloudFormationAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCloudFormationAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudFormationAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudFormationAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonCloudFormationAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCloudFormationAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudFormationAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudFormationAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonCloudFormationAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<Void> cancelUpdateStackAsync(CancelUpdateStackRequest request) {
        return this.cancelUpdateStackAsync(request, null);
    }

    @Override
    public Future<Void> cancelUpdateStackAsync(final CancelUpdateStackRequest request, final AsyncHandler<CancelUpdateStackRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudFormationAsyncClient.this.cancelUpdateStack(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ContinueUpdateRollbackResult> continueUpdateRollbackAsync(ContinueUpdateRollbackRequest request) {
        return this.continueUpdateRollbackAsync(request, null);
    }

    @Override
    public Future<ContinueUpdateRollbackResult> continueUpdateRollbackAsync(final ContinueUpdateRollbackRequest request, final AsyncHandler<ContinueUpdateRollbackRequest, ContinueUpdateRollbackResult> asyncHandler) {
        return this.executorService.submit(new Callable<ContinueUpdateRollbackResult>(){

            @Override
            public ContinueUpdateRollbackResult call() throws Exception {
                ContinueUpdateRollbackResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.continueUpdateRollback(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStackResult> createStackAsync(CreateStackRequest request) {
        return this.createStackAsync(request, null);
    }

    @Override
    public Future<CreateStackResult> createStackAsync(final CreateStackRequest request, final AsyncHandler<CreateStackRequest, CreateStackResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateStackResult>(){

            @Override
            public CreateStackResult call() throws Exception {
                CreateStackResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.createStack(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteStackAsync(DeleteStackRequest request) {
        return this.deleteStackAsync(request, null);
    }

    @Override
    public Future<Void> deleteStackAsync(final DeleteStackRequest request, final AsyncHandler<DeleteStackRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudFormationAsyncClient.this.deleteStack(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountLimitsResult> describeAccountLimitsAsync(DescribeAccountLimitsRequest request) {
        return this.describeAccountLimitsAsync(request, null);
    }

    @Override
    public Future<DescribeAccountLimitsResult> describeAccountLimitsAsync(final DescribeAccountLimitsRequest request, final AsyncHandler<DescribeAccountLimitsRequest, DescribeAccountLimitsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAccountLimitsResult>(){

            @Override
            public DescribeAccountLimitsResult call() throws Exception {
                DescribeAccountLimitsResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeAccountLimits(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStackEventsResult> describeStackEventsAsync(DescribeStackEventsRequest request) {
        return this.describeStackEventsAsync(request, null);
    }

    @Override
    public Future<DescribeStackEventsResult> describeStackEventsAsync(final DescribeStackEventsRequest request, final AsyncHandler<DescribeStackEventsRequest, DescribeStackEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStackEventsResult>(){

            @Override
            public DescribeStackEventsResult call() throws Exception {
                DescribeStackEventsResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeStackEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStackResourceResult> describeStackResourceAsync(DescribeStackResourceRequest request) {
        return this.describeStackResourceAsync(request, null);
    }

    @Override
    public Future<DescribeStackResourceResult> describeStackResourceAsync(final DescribeStackResourceRequest request, final AsyncHandler<DescribeStackResourceRequest, DescribeStackResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStackResourceResult>(){

            @Override
            public DescribeStackResourceResult call() throws Exception {
                DescribeStackResourceResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeStackResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStackResourcesResult> describeStackResourcesAsync(DescribeStackResourcesRequest request) {
        return this.describeStackResourcesAsync(request, null);
    }

    @Override
    public Future<DescribeStackResourcesResult> describeStackResourcesAsync(final DescribeStackResourcesRequest request, final AsyncHandler<DescribeStackResourcesRequest, DescribeStackResourcesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStackResourcesResult>(){

            @Override
            public DescribeStackResourcesResult call() throws Exception {
                DescribeStackResourcesResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeStackResources(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(DescribeStacksRequest request) {
        return this.describeStacksAsync(request, null);
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(final DescribeStacksRequest request, final AsyncHandler<DescribeStacksRequest, DescribeStacksResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeStacksResult>(){

            @Override
            public DescribeStacksResult call() throws Exception {
                DescribeStacksResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeStacks(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync() {
        return this.describeStacksAsync(new DescribeStacksRequest());
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(AsyncHandler<DescribeStacksRequest, DescribeStacksResult> asyncHandler) {
        return this.describeStacksAsync(new DescribeStacksRequest(), asyncHandler);
    }

    @Override
    public Future<EstimateTemplateCostResult> estimateTemplateCostAsync(EstimateTemplateCostRequest request) {
        return this.estimateTemplateCostAsync(request, null);
    }

    @Override
    public Future<EstimateTemplateCostResult> estimateTemplateCostAsync(final EstimateTemplateCostRequest request, final AsyncHandler<EstimateTemplateCostRequest, EstimateTemplateCostResult> asyncHandler) {
        return this.executorService.submit(new Callable<EstimateTemplateCostResult>(){

            @Override
            public EstimateTemplateCostResult call() throws Exception {
                EstimateTemplateCostResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.estimateTemplateCost(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EstimateTemplateCostResult> estimateTemplateCostAsync() {
        return this.estimateTemplateCostAsync(new EstimateTemplateCostRequest());
    }

    @Override
    public Future<EstimateTemplateCostResult> estimateTemplateCostAsync(AsyncHandler<EstimateTemplateCostRequest, EstimateTemplateCostResult> asyncHandler) {
        return this.estimateTemplateCostAsync(new EstimateTemplateCostRequest(), asyncHandler);
    }

    @Override
    public Future<GetStackPolicyResult> getStackPolicyAsync(GetStackPolicyRequest request) {
        return this.getStackPolicyAsync(request, null);
    }

    @Override
    public Future<GetStackPolicyResult> getStackPolicyAsync(final GetStackPolicyRequest request, final AsyncHandler<GetStackPolicyRequest, GetStackPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetStackPolicyResult>(){

            @Override
            public GetStackPolicyResult call() throws Exception {
                GetStackPolicyResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.getStackPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTemplateResult> getTemplateAsync(GetTemplateRequest request) {
        return this.getTemplateAsync(request, null);
    }

    @Override
    public Future<GetTemplateResult> getTemplateAsync(final GetTemplateRequest request, final AsyncHandler<GetTemplateRequest, GetTemplateResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTemplateResult>(){

            @Override
            public GetTemplateResult call() throws Exception {
                GetTemplateResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.getTemplate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTemplateSummaryResult> getTemplateSummaryAsync(GetTemplateSummaryRequest request) {
        return this.getTemplateSummaryAsync(request, null);
    }

    @Override
    public Future<GetTemplateSummaryResult> getTemplateSummaryAsync(final GetTemplateSummaryRequest request, final AsyncHandler<GetTemplateSummaryRequest, GetTemplateSummaryResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTemplateSummaryResult>(){

            @Override
            public GetTemplateSummaryResult call() throws Exception {
                GetTemplateSummaryResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.getTemplateSummary(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTemplateSummaryResult> getTemplateSummaryAsync() {
        return this.getTemplateSummaryAsync(new GetTemplateSummaryRequest());
    }

    @Override
    public Future<GetTemplateSummaryResult> getTemplateSummaryAsync(AsyncHandler<GetTemplateSummaryRequest, GetTemplateSummaryResult> asyncHandler) {
        return this.getTemplateSummaryAsync(new GetTemplateSummaryRequest(), asyncHandler);
    }

    @Override
    public Future<ListStackResourcesResult> listStackResourcesAsync(ListStackResourcesRequest request) {
        return this.listStackResourcesAsync(request, null);
    }

    @Override
    public Future<ListStackResourcesResult> listStackResourcesAsync(final ListStackResourcesRequest request, final AsyncHandler<ListStackResourcesRequest, ListStackResourcesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListStackResourcesResult>(){

            @Override
            public ListStackResourcesResult call() throws Exception {
                ListStackResourcesResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.listStackResources(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStacksResult> listStacksAsync(ListStacksRequest request) {
        return this.listStacksAsync(request, null);
    }

    @Override
    public Future<ListStacksResult> listStacksAsync(final ListStacksRequest request, final AsyncHandler<ListStacksRequest, ListStacksResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListStacksResult>(){

            @Override
            public ListStacksResult call() throws Exception {
                ListStacksResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.listStacks(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStacksResult> listStacksAsync() {
        return this.listStacksAsync(new ListStacksRequest());
    }

    @Override
    public Future<ListStacksResult> listStacksAsync(AsyncHandler<ListStacksRequest, ListStacksResult> asyncHandler) {
        return this.listStacksAsync(new ListStacksRequest(), asyncHandler);
    }

    @Override
    public Future<Void> setStackPolicyAsync(SetStackPolicyRequest request) {
        return this.setStackPolicyAsync(request, null);
    }

    @Override
    public Future<Void> setStackPolicyAsync(final SetStackPolicyRequest request, final AsyncHandler<SetStackPolicyRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudFormationAsyncClient.this.setStackPolicy(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> signalResourceAsync(SignalResourceRequest request) {
        return this.signalResourceAsync(request, null);
    }

    @Override
    public Future<Void> signalResourceAsync(final SignalResourceRequest request, final AsyncHandler<SignalResourceRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCloudFormationAsyncClient.this.signalResource(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateStackResult> updateStackAsync(UpdateStackRequest request) {
        return this.updateStackAsync(request, null);
    }

    @Override
    public Future<UpdateStackResult> updateStackAsync(final UpdateStackRequest request, final AsyncHandler<UpdateStackRequest, UpdateStackResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateStackResult>(){

            @Override
            public UpdateStackResult call() throws Exception {
                UpdateStackResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.updateStack(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ValidateTemplateResult> validateTemplateAsync(ValidateTemplateRequest request) {
        return this.validateTemplateAsync(request, null);
    }

    @Override
    public Future<ValidateTemplateResult> validateTemplateAsync(final ValidateTemplateRequest request, final AsyncHandler<ValidateTemplateRequest, ValidateTemplateResult> asyncHandler) {
        return this.executorService.submit(new Callable<ValidateTemplateResult>(){

            @Override
            public ValidateTemplateResult call() throws Exception {
                ValidateTemplateResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.validateTemplate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

