/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ListStacksRequestMarshaller
implements Marshaller<Request<ListStacksRequest>, ListStacksRequest> {
    public Request<ListStacksRequest> marshall(ListStacksRequest listStacksRequest) {
        if (listStacksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listStacksRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ListStacks");
        request.addParameter("Version", "2010-05-15");
        if (listStacksRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listStacksRequest.getNextToken()));
        }
        List<String> stackStatusFiltersList = listStacksRequest.getStackStatusFilters();
        int stackStatusFiltersListIndex = 1;
        for (String stackStatusFiltersListValue : stackStatusFiltersList) {
            if (stackStatusFiltersListValue != null) {
                request.addParameter("StackStatusFilter.member." + stackStatusFiltersListIndex, StringUtils.fromString((String)stackStatusFiltersListValue));
            }
            ++stackStatusFiltersListIndex;
        }
        return request;
    }
}

