/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class EstimateTemplateCostRequestMarshaller
implements Marshaller<Request<EstimateTemplateCostRequest>, EstimateTemplateCostRequest> {
    public Request<EstimateTemplateCostRequest> marshall(EstimateTemplateCostRequest estimateTemplateCostRequest) {
        SdkInternalList parametersList;
        if (estimateTemplateCostRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)estimateTemplateCostRequest, "AmazonCloudFormation");
        request.addParameter("Action", "EstimateTemplateCost");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (estimateTemplateCostRequest.getTemplateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)estimateTemplateCostRequest.getTemplateBody()));
        }
        if (estimateTemplateCostRequest.getTemplateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)estimateTemplateCostRequest.getTemplateURL()));
        }
        if (!(parametersList = (SdkInternalList)estimateTemplateCostRequest.getParameters()).isEmpty() || !parametersList.isAutoConstruct()) {
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.getParameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parametersListValue.getParameterKey()));
                }
                if (parametersListValue.getParameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parametersListValue.getParameterValue()));
                }
                if (parametersListValue.getUsePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parametersListValue.getUsePreviousValue()));
                }
                ++parametersListIndex;
            }
        }
        return request;
    }
}

