/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class UpdateStackRequestMarshaller
implements Marshaller<Request<UpdateStackRequest>, UpdateStackRequest> {
    public Request<UpdateStackRequest> marshall(UpdateStackRequest updateStackRequest) {
        if (updateStackRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateStackRequest, "AmazonCloudFormation");
        request.addParameter("Action", "UpdateStack");
        request.addParameter("Version", "2010-05-15");
        if (updateStackRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)updateStackRequest.getStackName()));
        }
        if (updateStackRequest.getTemplateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)updateStackRequest.getTemplateBody()));
        }
        if (updateStackRequest.getTemplateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)updateStackRequest.getTemplateURL()));
        }
        if (updateStackRequest.isUsePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringUtils.fromBoolean((Boolean)updateStackRequest.isUsePreviousTemplate()));
        }
        if (updateStackRequest.getStackPolicyDuringUpdateBody() != null) {
            request.addParameter("StackPolicyDuringUpdateBody", StringUtils.fromString((String)updateStackRequest.getStackPolicyDuringUpdateBody()));
        }
        if (updateStackRequest.getStackPolicyDuringUpdateURL() != null) {
            request.addParameter("StackPolicyDuringUpdateURL", StringUtils.fromString((String)updateStackRequest.getStackPolicyDuringUpdateURL()));
        }
        List<Parameter> parametersList = updateStackRequest.getParameters();
        int parametersListIndex = 1;
        for (Parameter parametersListValue : parametersList) {
            Parameter parameterMember = parametersListValue;
            if (parameterMember != null) {
                if (parameterMember.getParameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parameterMember.getParameterKey()));
                }
                if (parameterMember.getParameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parameterMember.getParameterValue()));
                }
                if (parameterMember.isUsePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parameterMember.isUsePreviousValue()));
                }
            }
            ++parametersListIndex;
        }
        List<String> capabilitiesList = updateStackRequest.getCapabilities();
        int capabilitiesListIndex = 1;
        for (String capabilitiesListValue : capabilitiesList) {
            if (capabilitiesListValue != null) {
                request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)capabilitiesListValue));
            }
            ++capabilitiesListIndex;
        }
        List<String> resourceTypesList = updateStackRequest.getResourceTypes();
        int resourceTypesListIndex = 1;
        for (String resourceTypesListValue : resourceTypesList) {
            if (resourceTypesListValue != null) {
                request.addParameter("ResourceTypes.member." + resourceTypesListIndex, StringUtils.fromString((String)resourceTypesListValue));
            }
            ++resourceTypesListIndex;
        }
        if (updateStackRequest.getStackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringUtils.fromString((String)updateStackRequest.getStackPolicyBody()));
        }
        if (updateStackRequest.getStackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringUtils.fromString((String)updateStackRequest.getStackPolicyURL()));
        }
        List<String> notificationARNsList = updateStackRequest.getNotificationARNs();
        int notificationARNsListIndex = 1;
        if (notificationARNsList.isEmpty() && !((ListWithAutoConstructFlag)notificationARNsList).isAutoConstruct()) {
            request.addParameter("NotificationARNs", "");
        }
        for (String notificationARNsListValue : notificationARNsList) {
            if (notificationARNsListValue != null) {
                request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringUtils.fromString((String)notificationARNsListValue));
            }
            ++notificationARNsListIndex;
        }
        return request;
    }
}

