/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.clouddirectory.model.AttributeNameAndValue;
import com.amazonaws.services.clouddirectory.model.ObjectReference;
import com.amazonaws.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import com.amazonaws.services.clouddirectory.model.transform.BatchAttachTypedLinkMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchAttachTypedLink
implements Serializable,
Cloneable,
StructuredPojo {
    private ObjectReference sourceObjectReference;
    private ObjectReference targetObjectReference;
    private TypedLinkSchemaAndFacetName typedLinkFacet;
    private List<AttributeNameAndValue> attributes;

    public void setSourceObjectReference(ObjectReference sourceObjectReference) {
        this.sourceObjectReference = sourceObjectReference;
    }

    public ObjectReference getSourceObjectReference() {
        return this.sourceObjectReference;
    }

    public BatchAttachTypedLink withSourceObjectReference(ObjectReference sourceObjectReference) {
        this.setSourceObjectReference(sourceObjectReference);
        return this;
    }

    public void setTargetObjectReference(ObjectReference targetObjectReference) {
        this.targetObjectReference = targetObjectReference;
    }

    public ObjectReference getTargetObjectReference() {
        return this.targetObjectReference;
    }

    public BatchAttachTypedLink withTargetObjectReference(ObjectReference targetObjectReference) {
        this.setTargetObjectReference(targetObjectReference);
        return this;
    }

    public void setTypedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
        this.typedLinkFacet = typedLinkFacet;
    }

    public TypedLinkSchemaAndFacetName getTypedLinkFacet() {
        return this.typedLinkFacet;
    }

    public BatchAttachTypedLink withTypedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
        this.setTypedLinkFacet(typedLinkFacet);
        return this;
    }

    public List<AttributeNameAndValue> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<AttributeNameAndValue> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<AttributeNameAndValue>(attributes);
    }

    public BatchAttachTypedLink withAttributes(AttributeNameAndValue ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<AttributeNameAndValue>(attributes.length));
        }
        for (AttributeNameAndValue ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public BatchAttachTypedLink withAttributes(Collection<AttributeNameAndValue> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceObjectReference() != null) {
            sb.append("SourceObjectReference: ").append(this.getSourceObjectReference()).append(",");
        }
        if (this.getTargetObjectReference() != null) {
            sb.append("TargetObjectReference: ").append(this.getTargetObjectReference()).append(",");
        }
        if (this.getTypedLinkFacet() != null) {
            sb.append("TypedLinkFacet: ").append(this.getTypedLinkFacet()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAttachTypedLink)) {
            return false;
        }
        BatchAttachTypedLink other = (BatchAttachTypedLink)obj;
        if (other.getSourceObjectReference() == null ^ this.getSourceObjectReference() == null) {
            return false;
        }
        if (other.getSourceObjectReference() != null && !other.getSourceObjectReference().equals(this.getSourceObjectReference())) {
            return false;
        }
        if (other.getTargetObjectReference() == null ^ this.getTargetObjectReference() == null) {
            return false;
        }
        if (other.getTargetObjectReference() != null && !other.getTargetObjectReference().equals(this.getTargetObjectReference())) {
            return false;
        }
        if (other.getTypedLinkFacet() == null ^ this.getTypedLinkFacet() == null) {
            return false;
        }
        if (other.getTypedLinkFacet() != null && !other.getTypedLinkFacet().equals(this.getTypedLinkFacet())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceObjectReference() == null ? 0 : this.getSourceObjectReference().hashCode());
        hashCode = 31 * hashCode + (this.getTargetObjectReference() == null ? 0 : this.getTargetObjectReference().hashCode());
        hashCode = 31 * hashCode + (this.getTypedLinkFacet() == null ? 0 : this.getTypedLinkFacet().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public BatchAttachTypedLink clone() {
        try {
            return (BatchAttachTypedLink)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchAttachTypedLinkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

