/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.AttributeKeyAndValue;
import com.amazonaws.services.clouddirectory.model.CreateObjectRequest;
import com.amazonaws.services.clouddirectory.model.SchemaFacet;
import com.amazonaws.services.clouddirectory.model.transform.AttributeKeyAndValueJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.ObjectReferenceJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.SchemaFacetJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateObjectRequestMarshaller
implements Marshaller<Request<CreateObjectRequest>, CreateObjectRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateObjectRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateObjectRequest> marshall(CreateObjectRequest createObjectRequest) {
        if (createObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createObjectRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.PUT);
        if (createObjectRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString((String)createObjectRequest.getDirectoryArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/object";
        request.setResourcePath(uriResourcePath);
        try {
            List<AttributeKeyAndValue> objectAttributeListList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<SchemaFacet> schemaFacetsList = createObjectRequest.getSchemaFacets();
            if (schemaFacetsList != null) {
                jsonGenerator.writeFieldName("SchemaFacets");
                jsonGenerator.writeStartArray();
                for (SchemaFacet schemaFacet : schemaFacetsList) {
                    if (schemaFacet == null) continue;
                    SchemaFacetJsonMarshaller.getInstance().marshall(schemaFacet, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((objectAttributeListList = createObjectRequest.getObjectAttributeList()) != null) {
                jsonGenerator.writeFieldName("ObjectAttributeList");
                jsonGenerator.writeStartArray();
                for (AttributeKeyAndValue objectAttributeListListValue : objectAttributeListList) {
                    if (objectAttributeListListValue == null) continue;
                    AttributeKeyAndValueJsonMarshaller.getInstance().marshall(objectAttributeListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createObjectRequest.getParentReference() != null) {
                jsonGenerator.writeFieldName("ParentReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(createObjectRequest.getParentReference(), jsonGenerator);
            }
            if (createObjectRequest.getLinkName() != null) {
                jsonGenerator.writeFieldName("LinkName").writeValue(createObjectRequest.getLinkName());
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

