/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.AttributeKeyAndValue;
import com.amazonaws.services.clouddirectory.model.BatchCreateObject;
import com.amazonaws.services.clouddirectory.model.SchemaFacet;
import com.amazonaws.services.clouddirectory.model.transform.AttributeKeyAndValueJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.ObjectReferenceJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.SchemaFacetJsonMarshaller;
import java.util.List;

public class BatchCreateObjectJsonMarshaller {
    private static BatchCreateObjectJsonMarshaller instance;

    public void marshall(BatchCreateObject batchCreateObject, StructuredJsonGenerator jsonGenerator) {
        if (batchCreateObject == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<AttributeKeyAndValue> objectAttributeListList;
            jsonGenerator.writeStartObject();
            List<SchemaFacet> schemaFacetList = batchCreateObject.getSchemaFacet();
            if (schemaFacetList != null) {
                jsonGenerator.writeFieldName("SchemaFacet");
                jsonGenerator.writeStartArray();
                for (SchemaFacet schemaFacetListValue : schemaFacetList) {
                    if (schemaFacetListValue == null) continue;
                    SchemaFacetJsonMarshaller.getInstance().marshall(schemaFacetListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((objectAttributeListList = batchCreateObject.getObjectAttributeList()) != null) {
                jsonGenerator.writeFieldName("ObjectAttributeList");
                jsonGenerator.writeStartArray();
                for (AttributeKeyAndValue objectAttributeListListValue : objectAttributeListList) {
                    if (objectAttributeListListValue == null) continue;
                    AttributeKeyAndValueJsonMarshaller.getInstance().marshall(objectAttributeListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (batchCreateObject.getParentReference() != null) {
                jsonGenerator.writeFieldName("ParentReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(batchCreateObject.getParentReference(), jsonGenerator);
            }
            if (batchCreateObject.getLinkName() != null) {
                jsonGenerator.writeFieldName("LinkName").writeValue(batchCreateObject.getLinkName());
            }
            if (batchCreateObject.getBatchReferenceName() != null) {
                jsonGenerator.writeFieldName("BatchReferenceName").writeValue(batchCreateObject.getBatchReferenceName());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BatchCreateObjectJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BatchCreateObjectJsonMarshaller();
        }
        return instance;
    }
}

